% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2_fill_layer.R
\name{scale_fill_academic_c}
\alias{scale_fill_academic_c}
\title{Scale Plot Fills With Academic Themes (Continuous)}
\usage{
scale_fill_academic_c(palette_name, ...)
}
\arguments{
\item{palette_name}{The name of a colour palette in \code{AcademicThemes}.}

\item{...}{Arguments passed to \code{ggplot2::scale_fill_gradientn()}}
}
\value{
A layer that can be added to a ggplot2 object.
}
\description{
Scale Plot Fills With Academic Themes (Continuous)
}
\examples{
library(ggplot2)
ggplot(
  data.frame(
    x = rnorm(10000),
    y = rnorm(10000)
  ),
  aes(x = x, y = y)
) +
  geom_hex() +
  scale_fill_academic_c("cruk") +
  theme_classic() +
  labs(
    x = "X-Axis",
    y = "Y-Axis",
    fill = "Fill"
  )
}
