% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/team_stats_per_minutes.R
\name{team_stats_per_minutes}
\alias{team_stats_per_minutes}
\title{Team stats per minutes}
\usage{
team_stats_per_minutes(df1, m)
}
\arguments{
\item{df1}{Should be a Data Frame that represents the team statistics. This parameter has to be in the format provided by the team_stats() function.}

\item{m}{Should be a number. This parameter has to be the number of minutes to which you want to project the statistics.}
}
\value{
Data frame with statistics by game projected to the minutes entered.
}
\description{
The function allows the calculation of the team statistics per game projected to M minutes.
}
\details{
The statistical projection is made from the relationship between the number of minutes entered and the number of minutes played by the team
}
\examples{

df1 <- data.frame("G" = c(71), "MP" = c(17090), "FG" = c(3006),
"FGA" = c(6269),"Percentage FG" = c(0.48), "3P" = c(782),
"3PA" = c(2242), "Percentage 3P" = c(0.349),  "2P" = c(2224),
"2PA" = c(4027), "Percentage 2P" = c(0.552), "FT" = c(1260),
"FTA FG" = c(1728),  "Percentage FT" = c(0.729), "ORB" = c(757),
"DRB" = c(2490),"TRB" = c(3247),  "AST" = c(1803),  "STL" = c(612),
"BLK" = c(468),   "TOV" = c(1077),  "PF" = c(1471),  "PTS" = c(8054),
"+/-" = c(0))

m <- 48

team_stats_per_minutes(df1,m)

}
\author{
Fco Javier Cantero \email{fco.cantero@edu.uah.es}

Juan José Cuadrado \email{jjcg@uah.es}

Universidad de Alcalá de Henares
}
