% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiclonesrules.R
\name{multiclonesrules}
\alias{multiclonesrules}
\title{Overview of the allocation rules with cloned agents}
\usage{
multiclonesrules(
  cw,
  eta,
  rules = c("SFC", "SEC", "CEC", "CEB", "CP", "SM", "CC", "SIGMA", "PRIOR"),
  group_contribution = TRUE,
  draw = TRUE,
  col = NULL,
  a = NULL,
  order = NULL,
  agents_names = NULL,
  labels = TRUE
)
}
\arguments{
\item{cw}{A numeric cost vector, with the same length as \code{eta}.}

\item{eta}{A numeric vector representing the size of each group of cloned agents. All its elements must be positive integers.}

\item{rules}{A character vector specifying the allocation rules. The available rules are:
\code{"SFC"}, \code{"SEC"}, \code{"CEC"}, \code{"CP"}, \code{"CEB"}, \code{"SM"}, \code{"CC"}, \code{"SIGMA"} and \code{"PRIOR"}. By default, all the rules
are selected.}

\item{group_contribution}{A logical value.
By default, if \code{group_contribution = TRUE}, the cost allocation vector stores the aggregated contribution for each group of clones.
However, if \code{group_contribution = FALSE}, the cost allocation vector represents the individual contribution of one of the agents in the group of clones.}

\item{draw}{A logical value indicating whether the plot should be generated. By default, \code{draw = TRUE}.}

\item{col}{A vector that indicates the colors used to represent each agent in the graphical representation. By default,
the colors are selected by the function \code{rainbow()}.}

\item{a}{A numeric value in the range [0,1], controlling the parameterization of the rule. It can only be defined when \code{"SIGMA"} is included in \code{rules}.
By default, \code{a = 0.5}.}

\item{order}{A numeric vector indicating the priority order of agents when making contributions. It can only be defined when \code{"PRIOR"} is included in \code{rules}.
By default, agents follow their original indexing and contribute accordingly.}

\item{agents_names}{A vector defining the name assigned to each group of clones. By default, the names follow a sequence of natural numbers, starting from 1.}

\item{labels}{A logical value indicating whether the labels and the title of the plot should be displayed. By default, \code{labels = TRUE}.}
}
\value{
A data frame containing the contribution vectors determined by the selected allocation rules. Additionally, if \code{draw = TRUE},
a mosaic plot displaying the allocations obtained for the different rules.
}
\description{
\code{multiclonesrules} calculates the contribution vectors resulting from the allocation of payments among different agents, applying the versions for clones of various predefined rules.
It also generates a graphical representation of the allocations based on the implemented rules.
}
\details{
Let \eqn{\mathcal{R}} be a rule, \eqn{t\in N}, and \eqn{(\eta,c)\in\mathcal{A}^N_t}. For each \eqn{i\in T=\{1,\dots,t\}},
the sum of the contributions requested by \eqn{\mathcal{R}} from the group of clones \eqn{N^{\eta}_i} is
\eqn{\mathcal{R}(\eta\ast c, N_i^{\eta})=\sum\limits_{j\in N^\eta_i}\mathcal{R}_j(n\ast c)}.

The computation of the cost allocation selected by a rule for a given problem can be substantially simplified where there are cloned agents.
Through this function, a direct method is proposed to obtain either the aggregate contribution or the individual contribution of each group of cloned agents,
based on the associated reduced problem and the number of clones in each group.

The version for clones of the SFC, SEC, CEC and CP rules is equal to their respective weighted version, so the formulation of these rules will be the same
for the weighted version. Only the CEB rule has a weighted version and a clone version that are different.

If a rule \eqn{\mathcal{R}} satisfies equal treatment of equals (cloned agents pay equal amounts), then
\eqn{\mathcal{R}(\eta\ast c,N_i^\eta)=\eta_i\mathcal{R}_s(n\ast c)} for any \eqn{s\in N_i^\eta}. All the rules listed, with the
exception of the PRIOR rule, satisfy equal treatment of equals. Therefore, the contribution demanded by these rules from a group of clones
is divided equally among them.

Finally, we define a \eqn{k}-replica of an airport problem as the problem in which every agent is replaced by \eqn{k} clones of itself.
If \eqn{k} increases, the number of groups of cloned agents does not change, but the number of agents is large. Thus, we say that a rule satisfies
replication invariance if for each \eqn{c\in C^N}, each \eqn{i \in N}, and each \eqn{k\in \mathbb{N}}, we have \eqn{\mathcal{R}(k\ast c,N_i^k)=\mathcal{R}_i(c)};
i.e., if in any \eqn{k}-replica of a problem each group of cloned agents contributes an amount independent of \eqn{k}.
The SFC, SEC, CEC, CP, and PRIOR rules verify this property, while the others do not.
}
\note{
When \code{"CC"} is included in the \code{rules} argument, the execution time of the function may significantly increase if the number of individual agents exceeds 150.
}
\examples{
# All rules for clones with graphical representation
cw <- c(1, 3, 7, 10) # Different costs
eta <- c(3, 4, 1, 2)  # Size of each groups of clones
multiclonesrules(cw, eta)

# SEC, CEC and CP rule for clones without plot
cw <- c(5, 10, 20) # Different costs
eta <- c(8, 2, 4) # Size of each groups of clones
multiclonesrules(cw, eta, rules = c("SEC", "CEC", "CP"),
group_contribution = FALSE, draw = FALSE,
agents_names = c("Suppliers", "Wholesalers", "Retailers"))

}
\references{
Bernárdez Ferradás, A., Mirás Calvo, M. Á., Quinteiro Sandomingo, C., and Sánchez-Rodríguez, E. (2025). Airport problems with cloned agents. [Preprint manuscript].

Littlechild, S. C. and Thompson, G. F. (1977). Aircraft landing fees: a game theory approach.
\emph{The Bell Journal of Economics}, 8, 186-204.
}
\seealso{
\code{\link{clonesgroups}}, \code{\link{clonesproblem}}, \code{\link{clonesrule}}, \code{\link{comparisonallocations}}, \code{\link{plotallocations}}
}
