% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotallocations.R
\name{plotallocations}
\alias{plotallocations}
\title{Graphical representation of the contribution vectors within the NS set}
\usage{
plotallocations(
  c,
  contributions,
  dimension = NULL,
  representation = "projection",
  col = NULL,
  colors = NULL,
  agents_names = NULL,
  labels = TRUE,
  contributions_names = NULL,
  tol = 1e-06
)
}
\arguments{
\item{c}{A numeric cost vector.}

\item{contributions}{A list containing different cost allocation vectors.}

\item{dimension}{A character string that specifies the dimension of the graphic. Possible values are \code{"1D"}, \code{"2D"}, and \code{"3D"}.
By default, the dimension is chosen based on the number of agents: \code{"1D"} for 2 agents, \code{"2D"} for 3 agents, and \code{"3D"} for 4 agents.}

\item{representation}{A character string indicating which NS set and allocations are displayed. Possible values are \code{"real"}, \code{"projection"}, and \code{"both"}. By default, \code{representation = "projection"}.}

\item{col}{A character string reflecting the color tone of the NS set. By default, the color tone \code{"dodgerblue"} is used.}

\item{colors}{A vector that indicates the colors used to represent each contribution vector. By default, a color palette of different shades is used.}

\item{agents_names}{A vector defining the name assigned to each agent. By default, the names follow a sequence of natural numbers, starting from 1.}

\item{labels}{A logical value indicating whether the coordinates of the points and the plot title should be displayed. By default, \code{labels = TRUE}.}

\item{contributions_names}{A vector defining the name assigned to each cost allocation vector. By default, and whenever \code{labels = TRUE}, the Cartesian coordinates of each point are displayed.}

\item{tol}{Tolerance level for evaluating compliance with the NS constraint.}
}
\value{
Only if the number of agents is 2, 3, or 4 will a plot be generated displaying the NS set and all cost allocation vectors.
}
\description{
\code{plotallocations} generates a graphical representation of the contribution vectors inside the NS set
in 1D, 2D, and 3D (available only when there are 2, 3, or 4 agents).
}
\details{
For each \eqn{c\in C^N} let \eqn{H(c)=\{x\in\mathbb{R}:x(N)=c_n\}} be the hyperplane of \eqn{\mathbb{R}^N}
given by all the vectors whose coordinates add up to \eqn{c_n}. A cost allocation for \eqn{c\in C^N} is a vector
\eqn{x\in H(c)} such that \eqn{0\leq x\leq c}. The component \eqn{x_i} is the contribution requested from agent \eqn{i}.
Let \eqn{X(c)} be the set of cost allocations for \eqn{c\in C^N}.

A basic requirement is that at an allocation \eqn{x\in X(c)} on group \eqn{N'\subset N}
of agents would subsidize the other agents by contributing more than what the group would have to pay on its own. The no-subsidy constraint
for the group \eqn{N'\subset N} is \eqn{x(N')\geq \text{max}\{c_j:j\in N'\}}. The set of cost allocations for \eqn{c\in C^N} that satisfy the no-subsidy
constraints, the no-subsidy set for short, is given by:
\deqn{
NS(c)=\{x\in X(c):x(N')\leq\text{max}\{c_j:j\in N'\}, \text{ for all } N'\subset N\}}
\deqn{= \{x\in \mathbb{R}^N:x\geq 0, \ x(N)=c_n, \ x_1+\dots+x_i\leq c_i,\text{ for all }i\in N\backslash \{n\}\}
}
Thus, the no-subsidy correspondence NS assigns to each \eqn{c\in C^N} the set \eqn{NS(c)}.

A rule is a mapping \eqn{\mathcal{R}:C^N\rightarrow \mathbb{R}^N} which associates with each problem \eqn{c\in C^N} a contribution vector
\eqn{\mathcal{R}(c)\in X(c)}. In other words, a rule is a mechanism that, for each airport problem, selects an allocation vector belonging to its no-subsidy set.
}
\examples{
# Projected SEC rule, CEC rule and SM rule for 3 agents
c <- c(5, 10, 20) # Cost vector
plotallocations(c, list(SECrule(c), CECrule(c), SMrule(c)), "2D",
"projection", contributions_names = c("SEC", "CEC", "SM"))

# Real an projected SM rule and PRIOR rule for 3 agentes
c <- c(1, 2, 3) # Cost vector
SM <- SMrule(c)
PRIOR <- PRIORrule(c, order = c(2, 3, 1))
plotallocations(c, list(SM, PRIOR), "3D", "both")

# Projected CEB rule and weighted CEB rule for 4 agents
c <- c(3, 3, 3, 10) # Cost vector
w <- c(1, 4, 8, 2) # Weight vector
CEB <- basicrule(c, "CEB")
wCEB <- weightedrule(c, w, "CEB")
plotallocations(c, list(CEB, wCEB), contributions_names = c("CEB", "wCEB"))

}
\references{
Bernárdez Ferradás, A., Mirás Calvo, M. Á., Quinteiro Sandomingo, C., and Sánchez-Rodríguez, E. (2025). Airport problems with cloned agents. [Preprint manuscript].

González-Díaz, J., Mirás Calvo, M. Á., Quinteiro Sandomingo, C., and Sánchez-Rodríguez, E. (2016). Airport games: the core and its center. \emph{Mathematical Social Sciences}, 82, 105–115.

Mirás Calvo, M. Á., Quinteiro Sandomingo, C., and Sánchez-Rodríguez, E. (2020). The boundary of the core of a balanced game: faces games.
\emph{International Journal of Game Theory}, 49(2), 579-599.
}
\seealso{
\code{\link{NSset}}, \code{\link{NScheck}}, \code{\link{comparisonallocations}}
}
