% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterObject.R
\name{getCSPEstimates}
\alias{getCSPEstimates}
\title{Return Codon Specific Paramters (or write to csv) estimates as data.frame}
\usage{
getCSPEstimates(
  parameter,
  filename = NULL,
  mixture = 1,
  samples = 10,
  relative.to.optimal.codon = T,
  report.original.ref = T,
  log.scale = F
)
}
\arguments{
\item{parameter}{parameter an object created by \code{initializeParameterObject}.}

\item{filename}{Posterior estimates will be written to file (format: csv). Filename will be in the format <parameter_name>_<filename>.csv.}

\item{mixture}{estimates for which mixture should be returned}

\item{samples}{The number of samples used for the posterior estimates.}

\item{relative.to.optimal.codon}{Boolean determining if parameters should be relative to the preferred codon or the alphabetically last codon (Default=TRUE). Only applies to ROC and FONSE models}

\item{report.original.ref}{Include the original reference codon (Default = TRUE). Note this is only included for the purposes of simulations, which expect the input parameter file to be in a specific format. Later version of AnaCoDa will remove this.}

\item{log.scale}{Calculate posterior means, standard deviation, and posterior probability intervals on the natural log scale. Should be used for PA and PANSE models only.}
}
\value{
returns a list data.frame with the posterior estimates of the models 
codon specific parameters or writes it directly to a csv file if \code{filename} is specified
}
\description{
\code{getCSPEstimates} returns the codon specific
parameter estimates for a given parameter and mixture or write it to a csv file.
}
\examples{
 
genome_file <- system.file("extdata", "genome.fasta", package = "AnaCoDa")

genome <- initializeGenomeObject(file = genome_file)
sphi_init <- c(1,1)
numMixtures <- 2
geneAssignment <- c(rep(1,floor(length(genome)/2)),rep(2,ceiling(length(genome)/2)))
parameter <- initializeParameterObject(genome = genome, sphi = sphi_init, 
                                       num.mixtures = numMixtures, 
                                       gene.assignment = geneAssignment, 
                                       mixture.definition = "allUnique")
model <- initializeModelObject(parameter = parameter, model = "ROC")
samples <- 2500
thinning <- 50
adaptiveWidth <- 25
mcmc <- initializeMCMCObject(samples = samples, thinning = thinning, 
                             adaptive.width=adaptiveWidth, est.expression=TRUE, 
                             est.csp=TRUE, est.hyper=TRUE, est.mix = TRUE) 
divergence.iteration <- 10
\dontrun{
runMCMC(mcmc = mcmc, genome = genome, model = model, 
        ncores = 4, divergence.iteration = divergence.iteration)

## return estimates for codon specific parameters
csp_mat <- getCSPEstimates(parameter)

# write the result directly to the filesystem as a csv file. No values are returned
getCSPEstimates(parameter, filename=file.path(tempdir(), "test.csv"))

}
}
