% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted_anchor_prediction.R
\name{weighted_anchor_prediction}
\alias{weighted_anchor_prediction}
\title{weighted_anchor_regression}
\usage{
weighted_anchor_prediction(names, coeff, x, anchor, gamma, target_variable)
}
\arguments{
\item{names}{list of variable names corresponding to the coefficients in coeff}

\item{coeff}{list of coefficients corresponding to the coefficients in names}

\item{x}{is a dataframe containing the matrix x containing the independent variables}

\item{anchor}{is a dataframe containing the matrix anchor containing the anchor variable}

\item{gamma}{is the regularization parameter for the Anchor Regression}

\item{target_variable}{is the target variable name contained in the x dataframe}
}
\value{
A list of predictions.
}
\description{
Perform a prediction for a Weighted Anchor Regression model
}
\examples{
   # number of observed environments
   environments <- 10

   # populate list with generated data of x and anchor
   data_x_list <- c()
   data_anchor_list <- c()
   for(e in 1:environments){
     x <- as.data.frame(matrix(data = rnorm(100),nrow = 100,ncol = 10))
     anchor <- as.data.frame(matrix(data = rnorm(200),nrow = 100,ncol = 2))
     colnames(anchor) <- c('X1','X2')
     data_x_list[[e]] <- x
     data_anchor_list[[e]]  <- anchor
   }

   # estimate model
   gamma <- 2
   target_variable <- 'V2'
   weighted_anchor_model <- weighted_anchor_regression(data_x_list,
                                                       data_anchor_list,
                                                       gamma,
                                                       target_variable,
                                                       anchor_model_pre=NULL,
                                                       test_split=0.4,
                                                       lambda=0)
   weighted_anchor_prediction(weighted_anchor_model$names,
                              weighted_anchor_model$coeff,
                              x,
                              anchor,
                              gamma,
                              target_variable)
}
