% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transition_entropy.R
\name{transition_entropy}
\alias{transition_entropy}
\title{Calculate Transition Entropy for Sequences}
\usage{
transition_entropy(sequences, ngram = 2, iterations = 20)
}
\arguments{
\item{sequences}{A list of sequences (character vectors) to analyze.}

\item{ngram}{The size of the n-gram (default is 2).}

\item{iterations}{The number of bootstrap iterations (default is 20).}
}
\value{
A data frame with calculated entropies, expected entropies, and entropy ratios for each iteration.
}
\description{
This function calculates the transition entropy for sequences using n-grams.
It performs bootstrapping to compute entropy and expected entropy over multiple iterations.
}
\examples{
sequences <- unlist(list("A B C", "B C A", "C A B"))
transition_entropy(sequences, ngram = 2, iterations = 20)

}
