% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pattern_recognition_distances.R
\name{DEcortNorm}
\alias{DEcortNorm}
\title{Normalized version of the Cort distance the modification is based on
using the coefficient of variation rather than euclidean distance,
performed by normalizing by the absolute value of the total differences
of the series.}
\usage{
DEcortNorm(k, S1, S2)
}
\arguments{
\item{k}{The parameter $k$ controls the contribution of the sum of squares
comparison as a value-based metric and the $Cort$ quantity as a behavioral
metric; when $k=0$, then the distance is equal to the value-based metric,
on the other hand, when $k=6$ the distance is mainly determined by the value
of the temporal correlation $Cort$.}

\item{S1}{A vector representing a univariate time series}

\item{S2}{A second vector representing a univariate time series}
}
\value{
a non-zero value
}
\description{
Normalized version of the Cort distance the modification is based on
using the coefficient of variation rather than euclidean distance,
performed by normalizing by the absolute value of the total differences
of the series.
}
\examples{
S1=rnorm(100)
S2=rnorm(100)
k=1
DEcortNorm(k,S1, S2)
}
\seealso{
Granados-Garcia, and Idris Eckley. "Building Electricity Demand
Benchmarking via a Regression Trees on Anomaly Scores"
}
