% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_decoupling.R
\name{calculate_decoupling}
\alias{calculate_decoupling}
\title{Calculate Aerobic Decoupling}
\usage{
calculate_decoupling(
  stoken,
  activity_type = c("Run", "Ride"),
  decouple_metric = c("Pace_HR", "Power_HR"),
  start_date = NULL,
  end_date = NULL,
  min_duration_mins = 45,
  max_activities = 50,
  stream_df = NULL
)
}
\arguments{
\item{stoken}{A valid Strava token from `rStrava::strava_oauth()`.}

\item{activity_type}{Type(s) of activities to analyze (e.g., "Run", "Ride").}

\item{decouple_metric}{Basis for calculation: "Pace_HR" or "Power_HR".}

\item{start_date}{Optional. Analysis start date (YYYY-MM-DD string or Date). Defaults to one year ago.}

\item{end_date}{Optional. Analysis end date (YYYY-MM-DD string or Date). Defaults to today.}

\item{min_duration_mins}{Minimum activity duration (minutes) to include. Default 45.}

\item{max_activities}{Maximum number of recent activities to analyze. Default 50.}

\item{stream_df}{Optional. A pre-fetched data frame for a *single* activity's stream.
If provided, calculates decoupling for this data directly, ignoring `stoken` and
other fetching parameters. Must include columns: `time`, `heartrate`, and either
`velocity_smooth`/`distance` (for Pace_HR) or `watts` (for Power_HR).}
}
\value{
Returns a data frame with `date` and `decoupling` [%] columns, OR
  a single numeric decoupling value if `stream_df` is provided.
}
\description{
Calculates aerobic decoupling for Strava activities.
}
\details{
Calculates aerobic decoupling (HR drift relative to pace/power) using detailed
Strava activity streams. Fetching streams via API can be slow.

Provides data for `plot_decoupling`. Compares output/HR efficiency
  between first and second halves of activities. Positive values indicate
  HR drift. Fetching streams via API using `httr` is slow and subject to rate limits.
}
\examples{
# Example using simulated data
data(Athlytics_sample_data)
print(head(athlytics_sample_decoupling))

\dontrun{
# Example using real data (requires authentication)
# To authenticate (replace with your details):
# stoken <- rStrava::strava_oauth(app_name = "YOUR_APP",
#                                client_id = "YOUR_ID",
#                                client_secret = "YOUR_SECRET",
#                                cache = TRUE)

# Calculate Pace/HR decoupling for recent Runs (limit to 10 activities for speed)
# Ensure stoken is defined and valid before running this part
# run_decoupling <- calculate_decoupling(
#     stoken = stoken,
#     activity_type = "Run",
#     decouple_metric = "Pace_HR",
#     max_activities = 10
# )
# print(tail(run_decoupling))
}
}
