% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viewer.R
\name{viewer3D}
\alias{viewer3D}
\title{Launch the Viewer.}
\usage{
viewer3D(urn = NULL, token = NULL, viewerType = "header")
}
\arguments{
\item{urn}{A string. Source URN (objectId) for the file. Note the URN must be
Base64 encoded. To encode the URN, see, for example, the
\code{jsonlite::base64_enc} function.}

\item{token}{A string. Token generated with \code{\link{getToken}} function
with \code{data:read} scope.}

\item{viewerType}{A string. The type of viewer to instantiate. Either
"header" for the default viewer, "headless" for a viewer without toolbar
or panels, or "vr" to enter WebVR mode on a mobile device.}
}
\description{
Launch the Viewer.
}
\examples{
\dontrun{
# View the "aerial.dwg" file in the AutoDesk viewer
myEncodedUrn <- jsonlite::base64_enc(myUrn)
viewer3D(urn <- myEncodedUrn, token = myToken)
}
}
