% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{split_data}
\alias{split_data}
\title{AutoScore Function: Automatically splitting dataset to train,
  validation and test set, possibly stratified by label}
\usage{
split_data(data, ratio, cross_validation = FALSE, strat_by_label = FALSE)
}
\arguments{
\item{data}{The dataset to be split}

\item{ratio}{The ratio for dividing dataset into training, validation and
testing set. (Default: c(0.7, 0.1, 0.2))}

\item{cross_validation}{If set to \code{TRUE}, cross-validation would be used
for generating parsimony plot, which is suitable for small-size data.
Default to \code{FALSE}}

\item{strat_by_label}{If set to \code{TRUE}, data splitting is stratified on
the outcome variable. Default to \code{FALSE}}
}
\value{
Returns a list containing training, validation and testing set
}
\description{
AutoScore Function: Automatically splitting dataset to train,
  validation and test set, possibly stratified by label
}
\examples{
data("sample_data")
names(sample_data)[names(sample_data) == "Mortality_inpatient"] <- "label"
set.seed(4)
#large sample size
out_split <- split_data(data = sample_data, ratio = c(0.7, 0.1, 0.2))
#small sample size
out_split <- split_data(data = sample_data, ratio = c(0.7, 0, 0.3),
                        cross_validation = TRUE)
#large sample size, stratified
out_split <- split_data(data = sample_data, ratio = c(0.7, 0.1, 0.2),
                        strat_by_label = TRUE)
}
