% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_postprodn_fns.R
\name{fix_label}
\alias{fix_label}
\title{Fix label switching in angmcmc objects}
\usage{
fix_label(object, ...)
}
\arguments{
\item{object}{angular MCMC object.}

\item{...}{arguments other than \code{z, K, complete, mcmc, p}
and \code{data} passed to \link[label.switching]{label.switching}. See details.}
}
\value{
Returns a single \code{angmcmc} object or a list of \code{angmcmc} objects (according as whether
the argument \code{method} is a scalar or vector) with label switchings corrected (after burn-in and thin)
according to the resulting permutation from \link[label.switching]{label.switching}.
}
\description{
Fix label switching in angmcmc objects
}
\details{
\code{fix_label} is a wrapper for  \link[label.switching]{label.switching} from
package \code{label.switching} for \code{angmcmc} objects. The arguments
\code{z, K, complete, mcmc, p} and \code{data} are appropriately filled in
from \code{object}. The \code{label.switching} argument \code{method} can
be a scalar or vector; for this wrapper it defaults to \code{"STEPHENS"} if the \code{angmcmc} was
created with permutation sampling (by setting perm_sampling = TRUE in
\link{fit_angmix}), and to \code{"DATA-BASED"} otherwise.
}
\examples{
# first fit a vmsin mixture model
# illustration only - more iterations needed for convergence
fit.vmsin.20 <- fit_vmsinmix(tim8, ncomp = 3, n.iter =  20,
                             n.chains = 1)
# now apply fix_label
fit.vmsin.20.fix <- fix_label(fit.vmsin.20)

}
