% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{bertopic_fit}
\alias{bertopic_fit}
\title{Fit BERTopic from R}
\usage{
bertopic_fit(text, embeddings = NULL, ...)
}
\arguments{
\item{text}{Character vector of documents.}

\item{embeddings}{Optional numeric matrix (n_docs x dim). If supplied, passed through to Python.}

\item{...}{Additional arguments forwarded to \code{bertopic.BERTopic(...)}.}
}
\value{
An S3 object of class "bertopic_r" containing:
\itemize{
\item \code{.py}: the underlying Python model (reticulate object)
\item \code{topics}: integer vector of topic assignments
\item \code{probs}: numeric matrix/data frame of topic probabilities (if available)
}
}
\description{
A high-level wrapper around Python 'BERTopic'. Python dependencies are checked at runtime.
}
\examples{
\dontrun{
if (reticulate::py_module_available("bertopic")) {
  m <- bertopic_fit(c("a doc", "another doc"))
  print(class(m))
}
}
}
