% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Species.R
\name{Species}
\alias{Species}
\alias{AddSpecies}
\alias{RemoveSpecies}
\title{Add or remove a species reactions in a problem}
\usage{
AddSpecies(
  ThisProblem,
  SpecEquation = character(),
  SpecName = character(),
  SpecMCName = NULL,
  SpecType = "Normal",
  SpecActCorr,
  SpecCompNames = list(),
  SpecCompStoichs = list(),
  SpecStoich = NULL,
  SpecLogK,
  SpecDeltaH,
  SpecTempKelvin,
  SpecMCR = match(SpecMCName, ThisProblem$Mass$Name, nomatch = -1L),
  InSpec = TRUE,
  DoCheck = TRUE
)

RemoveSpecies(ThisProblem, SpeciesToRemove, DoCheck = TRUE)
}
\arguments{
\item{ThisProblem}{A list object with a structure like that returned by
`BlankProblem()`.}

\item{SpecEquation}{A character vector giving the chemical equation for a
formation reaction. This must include the stoichiometric coefficients for
each reactant, even if it's 1. (e.g., the equation for the formation of
calcium chloride would be `"CaCl2 = 1 * Ca + 2 * Cl"`). If `SpecName` is
also supplied, then a partial equation with just the right hand side
(reactants) can be supplied (i.e., `"= 1 * Ca + 2 * Cl"`). Can be omitted
if either `SpecStoich` or both `SpecCompNames` and `SpecCompStoichs` are
supplied.}

\item{SpecName}{A character vector with the name(s) of the species to add
formation reactions for. Can be omitted if `SpecEquation` indicates the
species name.}

\item{SpecMCName}{A character vector with the name(s) of the mass
compartments the new species are associated with. Does not need to be
specified if `SpecMCR` is specified instead.}

\item{SpecType}{A character vector with the species type. SpecType values
must be either `"Normal"`, `"DonnanHA"`, `"DonnanFA"`, `"WHAMHA"`,
`"WHAMFA"`. The default value is `"Normal"`, while the others are usually
only needed for indicating species that are added from `ExpandWHAM`.}

\item{SpecActCorr}{A character vector with the activity correction method(s)
of the new species. Must be one of "None", "Debye", "Davies", "DonnanHA",
"DonnanFA", "WHAMHA", or "WHAMFA".}

\item{SpecCompNames}{A list where each element is a character vector of the
component names used to form each species. See examples for clarification.
Can be omitted if `SpecEquation` or `SpecStoich` is supplied.}

\item{SpecCompStoichs}{A list where each element is an integer vector of the
stoichiometric coefficients of each component used to form each species.
See examples for clarification. Can be omitted if `SpecEquation` or
`SpecStoich` is supplied.}

\item{SpecStoich}{A matrix of stoichiometric coefficients, where each row
corresponds to a chemical species and each column corresponds to a
component. The columns should match `ThisProblem$Comp$Name` exactly. Can be
omitted if either `SpecEquation` or both `SpecCompNames` and
`SpecCompStoichs` are supplied.}

\item{SpecLogK}{A numeric vector with the log10-transformed equilibrium
coefficients of the species formation reactions.}

\item{SpecDeltaH}{A numeric vector with the change in enthalpy of the species
formation reactions.}

\item{SpecTempKelvin}{A numeric vector with the temperatures (in Kelvin)
corresponding to `SpecDeltaH` values of the species formation reactions.}

\item{SpecMCR}{(optional) A character vector with the indices of the mass
compartments the new species are associated with. Only needs to be
specified if `SpecMCName` is not specified.}

\item{InSpec}{A logical value indicating if this is a species formation
reaction indicated from the parameter file (`TRUE`, the default) or a
reaction that was added from another process such as `ExpandWHAM`
(`FALSE`). This should usually only be `FALSE` when another function is
calling this function, such as `ExpandWHAM`.}

\item{DoCheck}{A logical value indicating whether checks should be performed
on the incoming and outgoing problem objects. Defaults to `TRUE`, as you
usually want to make sure something isn't awry, but the value is often set
to `FALSE` when used internally (like in DefineProblem) so the problem is
only checked once at the end.}

\item{SpeciesToRemove}{A character or integer vector indicating the names or
indices (respectively) of the species formation reactions to remove.}
}
\value{
`ThisProblem`, with the species reaction(s) changed.
}
\description{
Functions to add or remove species formation reactions.
}
\examples{
print(carbonate_system_problem$Spec)
my_new_problem = carbonate_system_problem
my_new_problem = AddInComps(ThisProblem = my_new_problem,
                            InCompName = "Ca",
                            InCompCharge = 2,
                            InCompMCName = "Water",
                            InCompType = "MassBal",
                            InCompActCorr = "Debye")
my_new_problem = AddSpecies(
  ThisProblem = my_new_problem,
  SpecEquation = c("CaCO3 = 1 * Ca + 1 * CO3",
                   "CaHCO3 = 1 * Ca + 1 * H + 1 * CO3"),
  SpecMCName = "Water",
  SpecActCorr = "Debye",
  SpecLogK = c(3.22, 11.44),
  SpecDeltaH = c(14951, -3664),
  SpecTempKelvin = 298.15
)
print(my_new_problem$Spec)
my_new_problem = RemoveSpecies(ThisProblem = my_new_problem,
                               SpeciesToRemove = "CaCO3")
print(my_new_problem$Spec)

}
\seealso{
Other problem manipulation functions: 
\code{\link{BlankProblem}()},
\code{\link{Components}},
\code{\link{CriticalValues}},
\code{\link{InLabs}},
\code{\link{InVars}},
\code{\link{MassCompartments}},
\code{\link{Phases}},
\code{\link{SpecialDefs}}
}
\concept{problem manipulation functions}
