% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WriteInputFile.R
\name{WriteInputFile}
\alias{WriteInputFile}
\title{Write a BLM input file}
\usage{
WriteInputFile(AllInput, ThisProblem, InputFile)
}
\arguments{
\item{AllInput}{A list object with a structure like that returned by
`GetData()`.}

\item{ThisProblem}{A list object with a structure like that returned by}

\item{InputFile}{`BlankProblem()`.}
}
\value{
TRUE (invisibly) if successful.
}
\description{
This function will take a BLM inputs list object and turn it
  into an input file, effectively doing the opposite of `GetData`.
}
\examples{
tf = tempfile()
myinputfile = system.file("extdata", "InputFiles",
                          "carbonate_system_test.blm4",
                          package = "BLMEngineInR",
                          mustWork = TRUE)
myinputs = GetData(InputFile = myinputfile,
                   ThisProblem = carbonate_system_problem)
WriteInputFile(AllInput = myinputs, ThisProblem = carbonate_system_problem,
               InputFile = tf)
scan(tf, what = character(), sep = "\n")
scan(myinputfile, what = character(), sep = "\n")
file.remove(tf)

}
