% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{lpYNODE}
\alias{lpYNODE}
\title{Network log-likelihood for individual updates}
\usage{
lpYNODE(Y, Z, alpha, node, diag, W)
}
\arguments{
\item{Y}{Adjacency matrix of the observed network}

\item{Z}{Latent positions matrix}

\item{alpha}{Model variable \eqn{\alpha}}

\item{node}{Specific node in the network corresponding to the latent coordinate which will be used as reference}

\item{diag}{Diagonal from \code{t(Z)\%*\%Z} matrix, passed to speed up the process.}

\item{W}{BLSM Weights matrix of the observed network}
}
\value{
Log-likelihood of the observed network
}
\description{
Compute the log-likelihood of the whole observed network based on the
latent positions estimates and the model assumptions. The function follows almost the same approach as \link[BLSM]{lpY}, but it is
more suitable for the individual updates occurring during the simulation.
}
