% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concor.R
\name{concor}
\alias{concor}
\title{Relative links of several subsets of variables}
\usage{
concor(x, y, py, r)
}
\arguments{
\item{x}{are the \code{n} times \code{p} and \code{n} times \code{q} matrices of \code{p} and \code{q} centered column}

\item{y}{See \code{x}}

\item{py}{The partition vector of y. A row vector containing the numbers \code{qi} for \code{i = 1,...,ky} of the \code{ky} subsets \code{yi} of \code{y : sum(qi)=sum(py)=q}.}

\item{r}{The number of wanted successive solutions}
}
\value{
A \code{list} with following components:
\item{u}{A \code{p} times \code{r} matrix of axes in \code{Rp} relative to \code{x; (u^prime)(u) = Identity}}
\item{v}{A \code{q} times \code{r} matrix of \code{ky} row blocks \code{vi (qi x r)} of axes in \code{Rqi} relative to \code{yi; vi^prime*vi = Identity}}
\item{V}{A \code{q} times \code{r} matrix of axes in \code{Rq} relative to \code{y; Vprime*V = Identity}}
\item{cov2}{A \code{ky} times \code{r} matrix; each column \code{k} contains \code{ky} squared covariances \eqn{\mbox{cov}(x*u[,k],y_i*v_i[,k])^2}, the partial measures of link}
}
\description{
Relative links of several subsets of variables Yj with another set X. SUCCESSIVE SOLUTIONS
}
\details{
The first solution calculates 1+kx normed vectors: the vector \code{u[:,1]} of Rp associated to the ky vectors \code{vi[:,1]}'s of Rqi,
by maximizing \eqn{\sum_i \mbox{cov}(x*u[,k],y_i*v_i[,k])^2}, with 1+ky norm constraints on the axes.
A component \code{(x)(u[,k])} is associated to ky partial components \code{(yi)(vi)[,k]} and to a global component \code{y*V[,k]}.
\eqn{\mbox{cov}((x)(u[,k]),(y)(V[,k]))^2 = \sum \mbox{cov}((x)(u[,k]),(y_i)(v_i[,k]))^2}.
\code{(y)(V[,k])} is a global component of the components \code{(yi)(vi[,k])}.
The second solution is obtained from the same criterion, but after replacing each yi by \eqn{y_i-(y_i)(v_i[,1])(v_i[,1]')}.
And so on for the successive solutions 1,2,...,r.  The biggest number of solutions may be r = inf(n, p, qi), when the (x')(yi')(s)
are supposed with full rank; then rmax = min(c(min(py),n,p)).  For a set of r solutions, the matrix u'X'YV is diagonal and the
matrices u'X'Yjvj are triangular (good partition of the link by the solutions).
concor.m is the svdcp.m function applied to the matrix x'y.
}
\examples{

# To make some "GPA" : so, by posing the compromise X = Y,
# "procrustes" rotations to the "compromise X" then are :
# Yj*(vj*u').
x <- matrix(runif(50),10,5);y <- matrix(runif(90),10,9)
x <- scale(x);y <- scale(y)
co <- concor(x,y,c(3,2,4),2)

}
\references{
Lafosse R. & Hanafi M.(1997) Concordance d'un tableau avec K tableaux: Definition de K+1 uples synthetiques. Revue de Statistique Appliquee vol.45,n.4.
}
\author{
\enc{Lafosse, R.}{R. Lafosse}
}
