% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Laminect}
\alias{Laminect}
\title{Median costs of laminectomies at hospitals across North Carolina in 1992}
\format{
A data frame/tibble with 138 observations on two variables
\describe{
 \item{area}{a character vector indicating the area of the hospital with \code{Rural}, \code{Regional},
 and \code{Metropol}} 
 \item{cost}{a numeric vector indicating cost of a laminectomy} 
 }
}
\source{
\emph{Consumer's Guide to Hospitalization Charges in North Carolina Hospitals} (August 1994),
North Carolina Medical Database Commission, Department of Insurance.
}
\usage{
Laminect
}
\description{
Data for Exercise 10.18
}
\examples{

boxplot(cost ~ area, data = Laminect, col = topo.colors(3))
anova(lm(cost ~ area, data = Laminect))

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
