% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/id_engagements.R
\name{id_engagements}
\alias{id_engagements}
\title{Engagements of (spatial) Bayesian brain mapping}
\usage{
id_engagements(
  bMap,
  u = NULL,
  z = 2,
  alpha = 0.01,
  type = c(">", "abs >", "<", "!="),
  method_p = c("BH", "bonferroni"),
  verbose = FALSE,
  which.nets = NULL,
  deviation = FALSE
)
}
\arguments{
\item{bMap}{Fitted (spatial) Bayesian brain map from \code{\link{fit_BBM}}.}

\item{u, z}{Set a threshold value for engagement? A threshold value can be
specified directly with \code{u}, or a z-score-like threshold in terms of
standard deviations (the SD of values in the mean prior) can be specified
with \code{z}. Only one type of threshold can be used. Default:
\code{z=2}. Set both \code{u} and \code{z} to \code{NULL} to not use a
threshold. Either \code{u} or \code{z} can also be a vector to test
multiple thresholds at once, as long as \code{type} is not \code{"!="}
(to ensure the engagement regions are successive subsets).}

\item{alpha}{Significance level for hypothesis testing. Default: \code{0.01}.}

\item{type}{Type of region: \code{">"} (default), \code{"abs >"}, \code{"<"},
or \code{"!="}. \code{"abs >"} tests for magnitude by taking the absolute
value and then testing if they are greater than... .}

\item{method_p}{If the input is a \code{"bMap.[format]"} model object, the
type of multiple comparisons correction to use for p-values, or \code{NULL}
for no correction. Default: \code{"BH"} (Benjamini & Hochberg, i.e. the
false discovery rate). Another option is \code{"bonferroni"} correction.
See \code{help(p.adjust)} for the full list of options. Note that multiple
comparisons will account for data locations, but not networks.}

\item{verbose}{If \code{TRUE}, display progress of algorithm. Default:
\code{FALSE}.}

\item{which.nets}{Indices of networks for which to identify engagements. If
\code{NULL} (default), use all networks.}

\item{deviation}{If \code{TRUE} identify significant deviations from the
prior mean, rather than significant areas of engagement. Default:
\code{FALSE}.}
}
\value{
A list containing engagement maps for each network, the joint and
marginal PPMs for each network, masks of regions meeting the threshold(s) if
provided, and the parameters used for computing engagement. If the input
represented CIFTI- or NIFTI-format data, then the engagements maps will be
formatted accordingly.

Use \code{summary} to obtain information about the engagements results.
For CIFTI-format engagements, use \code{plot} to visualize the engagement
maps.
}
\description{
Identify areas of engagement in each network from the result of (spatial)
Bayesian brain mapping.
}
\examples{
\dontrun{
 id_engagements(fit_BBM_result, alpha=.05, deviation=TRUE)
}
}
