% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runBayesMoFo.R
\name{runBayesMoFo}
\alias{runBayesMoFo}
\title{A function to fit mortality models.}
\usage{
runBayesMoFo(
  death,
  expo,
  models = NULL,
  family = "nb",
  forecast = FALSE,
  h = 5,
  n_iter = 1000,
  n.chain = 1,
  n.adapt = 1000,
  thin = 1,
  quiet = FALSE
)
}
\arguments{
\item{death}{death data that has been formatted through the function \code{preparedata_fn}.}

\item{expo}{expo data that has been formatted through the function \code{preparedata_fn}.}

\item{models}{a vector of strings specifying the models to run. If not specified, a standard set of models is run. If we set \code{models="all"}, all the possible models considered will be run.}

\item{family}{a string of characters that defines the family function associated with the mortality model. "poisson" would assume that deaths follow a Poisson distribution and use a log family; "binomial" would assume that deaths follow a Binomial distribution and a logit family; "nb" (default) would assume that deaths follow a Negative-Binomial distribution and a log family.}

\item{forecast}{a logical value indicating if forecast is to be performed (default is \code{FALSE}). See below for details.}

\item{h}{a numeric value giving the number of years to forecast. Default is \code{h=5}.}

\item{n_iter}{number of iterations to run. Default is \code{n_iter=1000}.}

\item{n.chain}{number of parallel chains for the model. Default is \code{n.chain=1}.}

\item{n.adapt}{the number of iterations for adaptation. See \code{?rjags::adapt} for details.}

\item{thin}{thinning interval for monitoring purposes.}

\item{quiet}{if TRUE then messages generated during compilation will be suppressed, as well as the progress bar during adaptation.}
}
\value{
A list with components:
\describe{
\item{\code{result}}{A list containing 2 lists, respectively called "best" (\code{$result$best}) and "worst" (\code{$result$best}). Both return the similar output as \code{fit_result}, with the former giving those of the best model while the latter giving those of the worst model.}
\item{\code{DIC}}{A table containing the numeric values of the DIC of all mortality models fitted.}
\item{\code{best_model}}{A character string indicating the best model (lowest DIC).}
\item{\code{worst_model}}{A character string indicating the worst model (highest DIC). If only one model was specified, then this is the same as \code{best_model}.}
\item{\code{BayesMoFo_obj}}{A logical value indicating whether the result has been generated using the function\code{runBayesMoFo} (default=TRUE).}
}
}
\description{
Carry out Bayesian estimation a selection of stochastic mortality models considered in the paper. \cr
DIC (Spiegelhalter et al., 2002) is used to perform model selection in determining the best/worst model for the specified (stratified) mortality data.
}
\details{
The standard set of models used (25 in total) is as follows: \cr
\code{M1A}, \code{M1M}, \code{M1U}, \code{M2A1}, \code{M2A2}, \code{M2Y1}, \code{M2Y2}, \cr
\code{MLiLee}, \code{MLiLee_sharealpha}, \cr
\code{CBD_M1}, \cr
\code{CBD_M2}, \code{CBD_M2_sharegamma}, \cr
\code{CBD_M3}, \code{CBD_M3_sharegamma}, \cr
\code{CBD_M5}, \cr
\code{CBD_M6}, \code{CBD_M6_sharegamma}, \cr
\code{CBD_M7}, \code{CBD_M7_sharegamma}, \cr
\code{CBD_M8}, \code{CBD_M8_sharegamma}, \cr
\code{APCI}, \code{APCI_sharegamma}, \cr
\code{PLAT}, \code{PLAT_sharegamma}.

The full list of mortality models fitted (44 in total) is as follows: \cr
\code{M1A}, \code{M1M}, \code{M1U}, \code{M2A1}, \code{M2A2}, \code{M2Y1}, \code{M2Y2}, \cr
\code{MLiLee}, \code{MLiLee_sharealpha}, \cr
\code{CBD_M1}, \code{CBD_M1_sharealpha}, \code{CBD_M1_sharebeta}, \code{CBD_M1_shareall}, \cr
\code{CBD_M2}, \code{CBD_M2_sharealpha}, \code{CBD_M2_sharebeta}, \code{CBD_M2_sharegamma}, \code{CBD_M2_sharealpha_sharebeta}, \code{CBD_M2_sharealpha_sharegamma}, \code{CBD_M2_sharebeta_sharegamma}, \code{CBD_M2_shareall}, \cr
\code{CBD_M3}, \code{CBD_M3_sharealpha}, \code{CBD_M3_sharegamma}, \code{CBD_M3_shareall}, \cr
\code{CBD_M5}, \cr
\code{CBD_M6}, \code{CBD_M6_sharegamma}, \cr
\code{CBD_M7}, \code{CBD_M7_sharegamma}, \cr
\code{CBD_M8}, \code{CBD_M8_sharegamma}, \cr
\code{APCI}, \code{APCI_sharealpha}, \code{APCI_sharebeta}, \code{APCI_sharegamma}, \code{APCI_sharealpha_sharebeta}, \code{APCI_sharealpha_sharegamma}, \code{APCI_sharebeta_sharegamma}, \code{APCI_shareall}, \cr
\code{PLAT}, \code{PLAT_sharealpha}, \code{PLAT_sharegamma}, \code{PLAT_shareall}.
}
\examples{
\donttest{
#load and prepare mortality data
data("dxt_array_product");data("Ext_array_product")
death<-preparedata_fn(dxt_array_product,strat_name = c("ACI","DB","SCI"),ages=35:65)
expo<-preparedata_fn(Ext_array_product,strat_name = c("ACI","DB","SCI"),ages=35:65)

##automatically find the best model from a standard set
runBayesMoFo_result<-runBayesMoFo(death=death,expo=expo,n_iter=50,n.adapt=50)
head(runBayesMoFo_result$result$best)
runBayesMoFo_result$DIC
runBayesMoFo_result$best_model

##if fit all the models
runBayesMoFo_result<-runBayesMoFo(death=death,expo=expo,models="all",
  n_iter=50,n.adapt=50)

# fit a subset of the models and forecast for 10 years 
runBayesMoFo_result<-runBayesMoFo(death=death,expo=expo,models=c("APCI","LC","PLAT"),
  n_iter=1000,n.adapt=1000,n.chain=2,forecast=TRUE,h=10)

##plot the best model
plot_rates_fn(runBayesMoFo_result)
plot_rates_fn(runBayesMoFo_result,plot_type="time",plot_ages=c(40,50,60))
plot_param_fn(runBayesMoFo_result)

##convergence diagnostics plots

#trace and density plots of death rates
converge_diag_rates_fn(runBayesMoFo_result)

#trace and density plots of parameters
converge_diag_param_fn(runBayesMoFo_result)

#ACF plots of death rates
converge_diag_rates_fn(runBayesMoFo_result, trace = FALSE, density = FALSE, acf_plot = TRUE)

#ACF plots of parameters
converge_diag_param_fn(runBayesMoFo_result, trace = FALSE, density = FALSE, acf_plot = TRUE)

#Some MCMC diagnostics (Gelman, Geweke, Heidel diagnostics etc.)
converge_diag_fn(runBayesMoFo_result)
}
}
\references{
Spiegelhalter, David J., Best, Nicola G., Carlin, Bradley P., and van der Linde, Angelika. (2002). "Bayesian measures of model complexity and fit (with discussion)". Journal of the Royal Statistical Society, Series B. 64 (4): 583–639.\doi{https://doi.org/10.1111/1467-9868.00353}
}
\concept{DIC}
\concept{stochastic mortality models}
\keyword{bayesian}
\keyword{estimation}
\keyword{model}
\keyword{selection}
