% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ext_array_country.R, R/dxt_array_country.R
\docType{data}
\name{Ext_array_country}
\alias{Ext_array_country}
\alias{dxt_array_country}
\title{Sample mortality data stratified by country}
\format{
An object of class \code{array} of dimension 5 x 96 x 50.

A 3-dimensional data array (dim 1: strata, dim 2: ages, dim 3: years) containing 5 countries, 96 ages, and 50 years:
\describe{
\item{Strata}{Character. Indicate the country (in total 5) origin of the data, labelled as: \cr
\code{"AUS"}: Australia; \cr
\code{"ITALY"}: Italy; \cr
\code{"JAPAN"}: Japan; \cr
\code{"UK"}: United Kingdom ;\cr
\code{"US"}: United States.}
\item{Ages}{Numeric. Ages at deaths, ranging between 0-95.}
\item{Years}{Numeric. Years at deaths, spanning years 1951-2000.}
}
}
\usage{
data("Ext_array_country")

data("dxt_array_country")
}
\description{
This is a sample data set used for demonstration purposes. They consist of two 3-dimensional arrays, one for number of deaths (\code{dxt_array_country}) and another for the the corresponding central exposures to risk (\code{Ext_array_country}).
}
\examples{
##Load exposure data
data("Ext_array_country")
str(Ext_array_country)
head(Ext_array_country)

#extracting a subset of the data (2 countries, ages 0-90, years 1961-2000)
Ext_array_country[c("AUS","JAPAN"),as.character(0:90),as.character(1961:2000)]

##Load death data
data("dxt_array_country")
str(dxt_array_country)
head(dxt_array_country)

#extracting a subset of the data (2 countries, ages 0-90, years 1961-2000)
dxt_array_country[c("AUS","JAPAN"),as.character(0:90),as.character(1961:2000)]

}
\keyword{datasets}
