% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNGP.R
\name{calculateAD_ns}
\alias{calculateAD_ns}
\title{Calculate A and D matrices for the NNGP approximation}
\usage{
calculateAD_ns(
  dist1_3d,
  dist2_3d,
  dist12_3d,
  Sigma11,
  Sigma22,
  Sigma12,
  log_sigma_vec,
  log_tau_vec,
  nID,
  N,
  k,
  nu,
  d
)
}
\arguments{
\item{dist1_3d}{N x (k+1) x (k+1) array of distances in the x-coordinate 
direction.}

\item{dist2_3d}{N x (k+1) x (k+1) array of distances in the y-coordinate 
direction.}

\item{dist12_3d}{N x (k+1) x (k+1) array of cross-distances.}

\item{Sigma11}{N-vector; 1-1 element of the Sigma() process.}

\item{Sigma22}{N-vector; 2-2 element of the Sigma() process.}

\item{Sigma12}{N-vector; 1-2 element of the Sigma() process.}

\item{log_sigma_vec}{N-vector; process standard deviation values.}

\item{log_tau_vec}{N-vector; nugget standard deviation values.}

\item{nID}{N x k matrix of neighbor indices.}

\item{N}{Scalar; number of data measurements.}

\item{k}{Scalar; number of nearest neighbors.}

\item{nu}{Scalar; Matern smoothness parameter.}

\item{d}{Scalar; dimension of the spatial domain.}
}
\value{
A N x (k+1) matrix; the first k columns are the 'A' matrix, and the
last column is the 'D' vector.
}
\description{
\code{calculateAD_ns} calculates A and D matrices (the Cholesky of the 
precision matrix) needed for the NNGP approximation.
}
