% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{as_bsim}
\alias{as_bsim}
\title{Construct a Fitted Model Object from Model Setup and MCMC Output}
\usage{
as_bsim(setup, mcmc.out)
}
\arguments{
\item{setup}{A \code{BayesSIM} setup object, typically the output of a
\code{_setup} function.}

\item{mcmc.out}{MCMC output corresponding to the result of a call to \code{runMCMC()}.}
}
\value{
An object of class \code{"bsim"} containing posterior samples,
point estimates, fitted values, and related model information.
}
\description{
Create a fitted \code{bsim} object by combining a \code{BayesSIM}
setup object with MCMC samples returned by \code{runMCMC()}.
}
\details{
This function is mainly intended for workflows where the model structure
and the MCMC sampling are performed separately. It collects the MCMC draws across chains, and returns an object of class \code{"bsim"}
that can be used with generic functions such as \code{summary()}, \code{plot()}, and \code{predict()}.
}
\examples{
\donttest{
simdata2 <- data.frame(DATA1$X, y = DATA1$y)
models <- BayesSIM_setup(y ~ ., data = simdata2)
Ccompile <- compileModelAndMCMC(models)
nimSampler <- get_sampler(Ccompile)
initList <- getInit(models)
mcmc.out <- runMCMC(nimSampler, niter = 5000, nburnin = 1000, thin = 1,
                   nchains = 1, setSeed = TRUE, inits = initList,
                   summary = TRUE, samplesAsCodaMCMC = TRUE)
fit2 <- as_bsim(models, mcmc.out)
summary(fit2)
}

}
