% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordered_logistic.R
\name{bi.dist.ordered_logistic}
\alias{bi.dist.ordered_logistic}
\title{Ordered Logistic Distribution}
\usage{
bi.dist.ordered_logistic(
  predictor,
  cutpoints,
  validate_args = py_none(),
  name = "x",
  obs = py_none(),
  mask = py_none(),
  sample = FALSE,
  seed = py_none(),
  shape = c(),
  event = 0,
  create_obj = FALSE,
  to_jax = TRUE
)
}
\arguments{
\item{predictor}{A numeric vector, matrix, or array representing the prediction in real domain; typically this is output of a linear model.}

\item{cutpoints}{A numeric vector, matrix, or array representing the positions in real domain to separate categories.}

\item{validate_args}{Logical: Whether to validate parameter values.  Defaults to `reticulate::py_none()`.}

\item{name}{A character string representing the name of the random variable
within a model. This is used to uniquely identify the variable. Defaults to 'x'.}

\item{obs}{A numeric vector or array of observed values. If provided, the
random variable is conditioned on these values. If `NULL`, the variable is
treated as a latent (unobserved) variable. Defaults to `NULL`.}

\item{mask}{An optional boolean vector to mask observations.}

\item{sample}{A logical value that controls the function's behavior. If `TRUE`,
the function will directly draw samples from the distribution. If `FALSE`,
it will create a random variable within a model. Defaults to `FALSE`.}

\item{seed}{An integer used to set the random seed for reproducibility when
`sample = TRUE`. This argument has no effect when `sample = FALSE`, as
randomness is handled by the model's inference engine. Defaults to 0.}

\item{shape}{A numeric vector used to shape the distribution. When `sample=False` (model building), this is used with `.expand(shape)` to set the distribution's batch shape. When `sample=True` (direct sampling), this is used as `sample_shape` to draw a raw JAX array of the given shape.}

\item{event}{An integer representing the number of batch dimensions to reinterpret as event dimensions (used in model building).}

\item{create_obj}{A logical value. If `TRUE`, returns the raw BI distribution object instead of creating a sample site.}

\item{to_jax}{Boolean. Indicates whether to return a JAX array or not.}
}
\value{
- When \code{sample=FALSE}, a BI Ordered Logistic distribution object (for model building).

 - When \code{sample=TRUE}, a JAX array of samples drawn from the Ordered Logistic distribution (for direct sampling).

 - When \code{create_obj=TRUE}, the raw BI distribution object (for advanced use cases).
}
\description{
The ordered logistic distribution is used for modeling **ordinal** outcome variables
\deqn{Y \in {1,2,\dots,K} } (i.e., categories with a natural order) via a latent continuous predictor \deqn{\eta } and
a set of increasing *cut-points* \deqn{ c_1 < c_2 < \cdots < c_{K-1} }. When \deqn{ \eta } crosses thresholds, the observed  \deqn{Y}.
}
\examples{
\donttest{
library(BayesianInference)
m=importBI(platform='cpu')
bi.dist.ordered_logistic(predictor = c(0.2, 0.5, 0.8), cutpoints = c(-1.0, 0.0, 1.0), sample = TRUE)
}
}
\seealso{
\url{https://num.pyro.ai/en/stable/distributions.html#orderedlogistic}
}
