% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_sampsize.R
\name{bayes_sampsize}
\alias{bayes_sampsize}
\title{Determine the required sample size for a Bayesian hypothesis test}
\usage{
bayes_sampsize(
  h1,
  h2,
  m1,
  m2,
  sd1 = 1,
  sd2 = 1,
  scale = 1000,
  type = 1,
  cutoff,
  bound1 = 1,
  bound2 = 1/bound1,
  datasets = 1000,
  nsamp = 1000,
  minss = 2,
  maxss = 1000,
  seed = 31
)
}
\arguments{
\item{h1}{A constraint matrix defining H1.}

\item{h2}{A constraint matrix defining H2.}

\item{m1}{A vector of expected population means under H1 (standardized).}

\item{m2}{A vector of expected populations means under H2 (standardized).
\code{m2} must be of same length as \code{m1}}

\item{sd1}{A vector of standard deviations under H1. Must be a single number (equal
standard deviation under all populations), or a vector of the same length as \code{m1}}

\item{sd2}{A vector of standard deviations under H2. Must be a single number (equal
standard deviation under all populations), or a vector of the same length as \code{m2}}

\item{scale}{A number specifying the prior scale}

\item{type}{A character. The type of error to be controlled
options are: \code{"1", "2", "de", "aoi", "med.1", "med.2"}}

\item{cutoff}{A number. The cutoff criterion for type.
If \code{type} is \code{"1", "2", "de", "aoi"}, \code{cutoff} must be between 0 and 1
If \code{type} is \code{"med.1" or "med.2"}, \code{cutoff} must be larger than 1}

\item{bound1}{A number. The boundary above which BF12 favors H1}

\item{bound2}{A number. The boundary below which BF12 favors H2}

\item{datasets}{A number. The number of datasets to compute the error probabilities}

\item{nsamp}{A number. The number of prior or posterior samples to determine the
fit and complexity}

\item{minss}{A number. The minimum sample size to consider}

\item{maxss}{A number. The maximum sample size to consider}

\item{seed}{A number. The random seed to be set}
}
\value{
The sample size for which the chosen type of error probability
is at the set cutoff, and the according error probabilities and median Bayes factors
}
\description{
Determine the required sample size for a Bayesian hypothesis test
}
\examples{
# Short computation example NOT SUFFICIENT SAMPLES
h1 <- matrix(c(1,-1), nrow= 1, byrow= TRUE)
h2 <- 'c'
m1 <- c(.4, 0)
m2 <- c(0, .1)
bayes_sampsize(h1, h2, m1, m2, sd1 = 1, sd2 = 1, scale = 1000,
type = "de", cutoff = .125, nsamp = 50, datasets = 50,
minss = 40, maxss = 70)
}
