% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asymcp.r
\name{asymcp}
\alias{asymcp}
\title{Conditional power computation using asymptotic test.}
\usage{
asymcp(d, p_1, i, z_i)
}
\arguments{
\item{d}{An object of the class asymdesign or asymprob.}

\item{p_1}{A scalar or vector representing response rate or probability of success under the alternative hypothesis. The
value(s) should be within (p_0,1).}

\item{i}{Index of the analysis at which the interim statistic is given. Should be an integer ranges from 1 to K-1. i will be
rounded to its nearest whole value if it is not an integer.}

\item{z_i}{The interim statistic at analysis i.}
}
\value{
A list with the elements as follows:
\itemize{
  \item{K: As in d.}
  \item{n.I: As in d.}
  \item{u_K: As in d.}
  \item{lowerbounds: As in d.}
  \item{i: i used in computation.}
  \item{z_i: As input.}
  \item{cp: A matrix of conditional powers under different response rates.}
  \item{p_1: As input.}
  \item{p_0: As input.}
}
}
\description{
Compute conditional power of single-arm group sequential design with binary endpoint based on asymptotic test, given the interim
result.
}
\details{
Conditional power quantifies the conditional probability of crossing the upper bound given the interim result \eqn{z_i},
\eqn{1\le i<K}. Having inherited sample sizes and boundaries from \code{\link{asymdesign}} or \code{\link{asymprob}},
given the interim statistic at \eqn{i}th analysis \eqn{z_i}, the conditional power is defined as

\eqn{\alpha _{i,K}(p|z_i)=P_{p}(Z_K\ge u_K, Z_{K-1}>l_{K-1}, \ldots, Z_{i+1}>l_{i+1}|Z_i=z_i)}

With asymptotic test, the test
statistic at analysis \eqn{k} is
\eqn{Z_k=\hat{\theta}_k\sqrt{n_k/p/(1-p)}=(\sum_{s=1}^{n_k}X_s/n_k-p_0)\sqrt{n_k/p/(1-p)}},
which follows the normal distribution \eqn{N(\theta \sqrt{n_k/p/(1-p)},1)}
with \eqn{\theta=p-p_0}. In practice, \eqn{p} in \eqn{Z_k} can be substituted
with the sample response rate \eqn{\sum_{s=1}^{n_k}X_s/n_k}.

The increment statistic \eqn{Z_k\sqrt{n_k/p/(1-p)}-Z_{k-1}\sqrt{n_{k-1}/p/(1-p)}} also follows a normal distribution independently
of \eqn{Z_{1}, \ldots, Z_{k-1}}. Then the conditional power can be easily obtained using a procedure similar
to that for unconditional boundary crossing probabilities.
}
\section{Reference}{
 \itemize{
 \item{Alan Genz et al. (2018). mvtnorm: Multivariate Normal and t Distributions. R package version 1.0-11.}}
}

\examples{
I=c(0.2,0.4,0.6,0.8,0.99)
beta=0.2
betaspend=c(0.1,0.2,0.3,0.3,0.2)
alpha=0.05
p_0=0.3
p_1=0.5
K=4.6
tol=1e-6
tt1=asymdesign(I,beta,betaspend,alpha,p_0,p_1,K,tol)
tt2=asymprob(p_1=c(0.4,0.5,0.6,0.7,0.8,0.9),d=tt1)
asymcp(tt1,p_1=c(0.4,0.5,0.6,0.7,0.8,0.9),1,2)
asymcp(tt2,p_1=c(0.4,0.5,0.6,0.7,0.8,0.9),3,2.2)
}
\seealso{
\code{\link{asymprob}}, \code{\link{asymdesign}},
 \code{\link{exactcp}}.
}
