% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesianFit.R
\name{BayesianFit}
\alias{BayesianFit}
\title{Fit the Bayesian model for Binary Replicates}
\usage{
BayesianFit(
  ni,
  si,
  prior = list(a_FP = 2, b_FP = 2, a_FN = 2, b_FN = 2, a_T = 0.5, b_T = 0.5),
  ...
)
}
\arguments{
\item{ni}{Numeric vector of \eqn{n_i}'s, the total numbers of replicates for each individual}

\item{si}{Numeric vector of \eqn{s_i}'s, the numbers of replicates equal to 1 for each individual}

\item{prior}{A list of prior parameters for the model, see Details.}

\item{...}{Arguments passed to \code{rstan::sampling} (e.g. iter, chains).}
}
\value{
An object of class \code{stanfit} returned by \code{rstan::sampling}.

The Stan model samples the posterior distribution of the fixed parameters \eqn{p},
\eqn{q} and \eqn{\theta}. It also generates the latent variables \eqn{T_i} according
to their predictive distribution.
}
\description{
Fit the Bayesian model for Binary Replicates
}
\details{
The model is a Bayesian model for binary replicates.
The prior distribution is as follows:

\itemize{
\item The false positive rate: \eqn{p \sim \text{Beta}(a_{FP}, b_{FP})}
\item The false negative rate: \eqn{q \sim \text{Beta}(a_{FN}, b_{FN})}
\item The prevalence: \eqn{\theta \sim \text{Beta}(a_T, b_T)}
}

The statistical model considers that the true statuses are the latent
\deqn{T_i \sim \text{Bernoulli}(\theta).}

And, given the true status \eqn{T_i}, the number of positive replicates is
\deqn{S_i \sim \text{Binomial}(n_i, T_i(1-q)+(1-T_i)p).}
}
\seealso{
\link{credint}, \link{bayesian_scoring}, \link{classify_with_scores},
\link{bayesian_prevalence_estimate}
}
