% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experimental-features.R
\name{exploratory_tr_curve}
\alias{exploratory_tr_curve}
\title{Plot an exploratory temperature response curve.}
\usage{
exploratory_tr_curve(
  cbass_dataset,
  grouping_properties = c("Site", "Condition", "Species", "Timepoint"),
  faceting = "Species ~ Site ~ Condition",
  size_text = 12,
  size_points = 2
)
}
\arguments{
\item{cbass_dataset}{A data frame containing the dataset to be processed.}

\item{grouping_properties}{A character vector of column names to be used for grouping. Default: c("Site", "Condition", "Species", "Timepoint").}

\item{faceting}{A formula specifying the faceting of the plot. Default: "Species ~ Site ~ Condition".}

\item{size_text}{Default: 12. A formula specifying the faceting of the plot.}

\item{size_points}{Default: 2. A formula specifying the faceting of the plot.}
}
\value{
A ggplot object representing the temperature response curve.
}
\description{
Plot an exploratory temperature response curve.
}
\examples{
# Load example dataset
data(cbass_dataset)

# Create an exploratory temperature response curve
exploratory_curve <- exploratory_tr_curve(cbass_dataset)
}
