% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run-ed50-analysis.R
\name{get_ed50_by_grouping_property}
\alias{get_ed50_by_grouping_property}
\title{Get ED50 by Grouping Property}
\usage{
get_ed50_by_grouping_property(models)
}
\arguments{
\item{models}{A list of models where each element represents a model object containing coefficients.}
}
\value{
A data frame containing the ED50 values along with their corresponding grouping property.
        Each row represents a model's ED50 value and its associated grouping property.
}
\description{
This function takes a list of models and extracts the ED50 value for each model based on a specified grouping property.
The ED50 value is extracted from the model's coefficients and is associated with the intercept term.
}
\examples{
data(cbass_dataset)
preprocessed_data <- preprocess_dataset(cbass_dataset)
model_list <-fit_drms(preprocessed_data,
           c("Site", "Condition", "Species", "Genotype"),
            "Pam_value ~ Temperature")
ed50_data <- get_ed50_by_grouping_property(model_list)

# Resulting data frame structure:
#   ED50     GroupingProperty
# 1 ED50_value_1 Group1
# 2 ED50_value_2 Group2
}
