% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdss_read_skll_assignments_xlsx.R
\name{cdss_read_skill_assignment_xlsx}
\alias{cdss_read_skill_assignment_xlsx}
\title{Read an assignment of taught and required skills for a set of learning objects from an XLSX-file.}
\usage{
cdss_read_skill_assignment_xlsx(
  filename,
  taughtname = "Taught",
  requiredname = "Required",
  warnonly = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{filename}{Name of the XLSX-file}

\item{taughtname}{Name of the sheet with required assignment (default = "Taught")}

\item{requiredname}{Name of the sheet with required assignment (default = "Required")}

\item{warnonly}{Are non-compliant SAs allowed? (default = FALSE)}

\item{verbose}{Verbosity of compliance test (default = TRUE)}
}
\value{
List of two binary matrices, "taught" and "required".
}
\description{
\code{cdss_read_skill_assignment_xlsx} expects an XLSX-file with two sheets assigning taught and
required, respectively, skills to learning objects with two columns each. The first
column contains the IDs of learning objects and the second row the IDs of single skills
required or taught, respectively, by this learning object.
It returns a list of two binary matrices, "taught" and "required". Each matrix has one
row per learning object and one column per skill. The cells contain a "1" if the skill
is taught or required, respectively, by the learning object and a "0" otherwise,
}
\seealso{
Other functions reading skill assignments: 
\code{\link{cdss_read_skill_assignment_csv}()},
\code{\link{cdss_read_skill_assignment_ods}()},
\code{\link{cdss_wf_read_skill_assignment}()}
}
\concept{functions reading skill assignments}
