% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cin_metrics.R
\name{fga}
\alias{fga}
\title{Fraction Genome Altered}
\usage{
fga(cnvData, segmentMean = 0.2, numProbes = NA, genomeSize = 2873203431)
}
\arguments{
\item{cnvData}{dataframe containing following columns: Sample, Start, End, Num_Probes, Segment_Mean}

\item{segmentMean}{numerical value for the minimum segment_mean cutoff/ threshold. Default is 0.2}

\item{numProbes}{Number of Probes}

\item{genomeSize}{Size of the genome derived from Affymetrix 6.0 array probe. Default is 2873203431 calculated based on hg38 **excluding sex chromosomes**}
}
\value{
Fraction of the genome altered
}
\description{
Fraction Genome Altered looks at the fraction of the genome that deviates from a diploid state
fga calculates the fraction of the genome altered (FGA; [Chin SF, et. al.](https://www.ncbi.nlm.nih.gov/pubmed/17925008)), measured by taking the sum of the number of bases altered and dividing it by the genome length covered ($G$). Genome length covered was calculated by summing the lengths of each probe on the Affeymetrix 6.0 array. This calculation **excludes** sex chromosomes.
\deqn{
Fraction\ Genome\ Altered =
\frac
{\sum^{R}_{i = 1} d_i}
{G}
\ \ where\  |\bar{y}_{S_i}| \ge 0.2
}
}
\examples{
fga(cnvData = maskCNV_BRCA)
}
