% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Boot.functions.R
\name{bootstrap}
\alias{bootstrap}
\title{Bootstrap}
\usage{
bootstrap(
  dataset,
  n.boot = 10^5,
  variables,
  stress_variable,
  alpha = 0.05,
  ran.seed = 12345
)
}
\arguments{
\item{dataset}{Data set to be utilized.}

\item{n.boot}{Number of bootstraps to perform. Defaults to 10^5.}

\item{variables}{List of variables from mean and variance models in DGLM.}

\item{stress_variable}{Name of the variable with the stress values.}

\item{alpha}{Significance level by which to determine the confidence intervals for the bootstrap estimates. Defaults to 0.05, thus creating the 95 percent confidence intervals.}

\item{ran.seed}{Random seed value for generating different random bootstrap samples.]}
}
\value{
Lists with confidence intervals for the bootstrap estimations for average stress in As and Bs of variables in mean model and confidence intervals for the bootstrap estimations of standard deviation of stress in As and Bs of variables in variance model.
}
\description{
This function implements a custom bootstrapping procedure that utilizes bootstrapping to estimate mean and SD of stress between two environment states (A and B).
}
\examples{
test.data <- simu.inter.dat.interboth(n.rep = 3, n.obs.per.rep = 15, ran.seed = 1)
variables <- colnames(test.data[-1])
bootstrap(test.data, n.boot=100,variables, 'stress')
unlink(c('bootstrap mean A stress.txt','bootstrap mean B stress.txt',
'bootstrap sd A stress.txt', 'bootstrap sd B stress.txt'))
}
