% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Boot.functions.R
\name{sd.stress}
\alias{sd.stress}
\title{Standard Deviation Stress}
\usage{
sd.stress(
  dataset,
  var,
  stress_variable,
  output.name = "sd_stress.txt",
  use.output = TRUE,
  bin.levels = c(0, 1)
)
}
\arguments{
\item{dataset}{Data set to be utilized. For the purposes of this function, the binary values in each variable are considered to be -1 and 1.}

\item{var}{A list of variables. If using variables from a DGLM, use the variables from the variance model (or, if trying to find intervals for use in the plotting functions draw.crossplots and draw.squareplots, use all variables in both mean and variance models).}

\item{stress_variable}{Name of the variable with the stress values.}

\item{output.name}{Name of the output file to which to save the outputs. Defaults to 'sd_stress.txt'.}

\item{use.output}{A binary variable to indicate whether the output is automatically saved to an external text file. Defaults to TRUE. If FALSE, the output will not be saved to a file.}

\item{bin.levels}{A list that provides the binary values utilized in the dataset. Defaults to c(0,1), indicating that 0 and 1 are used as the binary outcomes; can also be 1, -1. List the value for the "A" environment level first, then the value for the "B" environment level.}
}
\value{
Produces a data frame with three columns: var, sd1, and sdneg1. These provide the variable and its corresponding standard deviation of stress values for As and Bs, corresponding to different environment levels.
}
\description{
This function provides the mean stress among As and Bs, corresponding to different environment levels, for a list of variables.
}
\examples{
test.data <- simu.inter.dat.interboth(n.rep = 3, n.obs.per.rep = 15, ran.seed = 1)
variables <- colnames(test.data[-1])
sd.stress(test.data, variables, 'stress', use.output = FALSE)
}
