% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnosticplots_class.R
\name{diagnosticplots_class}
\alias{diagnosticplots_class}
\title{Diagnostic Plots for Model Discrimination}
\usage{
diagnosticplots_class(model)
}
\arguments{
\item{model}{A fitted logistic regression model object of class \code{glm}, with a binary outcome.}
}
\value{
This function displays a 2x2 grid of diagnostic plots.
}
\description{
Generates four diagnostic plots to evaluate the discriminatory ability of a logistic regression model.
These plots follow the style of those presented by Hosmer et al. (2013) and are helpful for visually
assessing model performance.
}
\details{
This function creates the following diagnostic plots:
\enumerate{
\item A jitter plot showing the distribution of the estimated probabilities against the observed outcome.
\item An ROC curve displaying sensitivity versus 1-specificity.
\item A histogram of estimated probabilities for observations with outcome = 0.
\item A histogram of estimated probabilities for observations with outcome = 1.
}
}
\examples{
# Example from Hosmer et al., 2013
# Applied Logistic Regression (3rd ed.), Chapter 5, Section 5.2.4

# Recode 'raterisk' into a binary variable 'raterisk_cat'
glow500 <- dplyr::mutate(
  glow500,
  raterisk_cat = dplyr::case_when(
    raterisk \%in\% c("Less", "Same") ~ "C1",
    raterisk == "Greater" ~ "C2"
  )
)

# Fit a multiple logistic regression model with interactions
model.int <- glm(
  fracture ~ age + height + priorfrac + momfrac + armassist +
    raterisk_cat + age * priorfrac + momfrac * armassist,
  family = binomial,
  data = glow500
)

# Generate classification diagnostic plots
diagnosticplots_class(model.int)

}
\references{
Hosmer, D. W., Lemeshow, S., & Sturdivant, R. X. (2013). \emph{Applied Logistic Regression}
(3rd ed.). John Wiley & Sons, Inc.
}
\seealso{
\code{\link{cutpoints}}
}
