% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProbabilityFunctions.R
\name{sim_Vn_stat}
\alias{sim_Vn_stat}
\title{CUSUM Statistic Simulation}
\usage{
sim_Vn_stat(size, kn = function(n) {     1 }, tau = 0,
  use_kernel_var = FALSE, kernel = "ba", bandwidth = "and",
  n = 500, gen_func = rnorm, args = NULL, parallel = FALSE)
}
\arguments{
\item{size}{Number of realizations to simulate}

\item{kn}{A function returning a positive integer that is used in the
definition of the trimmed CUSUSM statistic effectively setting the
bounds over which the maximum is taken}

\item{tau}{The weighting parameter for the weighted CUSUM statistic (defaults
to zero for no weighting)}

\item{use_kernel_var}{Set to \code{TRUE} to use kernel-based long-run
variance estimation (\code{FALSE} means this is not
employed)}

\item{kernel}{If character, the identifier of the kernel function as used in
the \pkg{cointReg} (see documentation for
\code{cointReg::getLongRunVar}); if function, the kernel
function to be used for long-run variance estimation (default
is the Bartlett kernel in \pkg{cointReg}); this parameter
has no effect if \code{use_kernel_var} is \code{FALSE}}

\item{bandwidth}{If character, the identifier of how to compute the bandwidth
as defined in the \pkg{cointReg} package (see
documentation for \code{cointReg::getLongRunVar}); if
function, a function to use for computing the bandwidth; if
numeric, the bandwidth to use (the default behavior is to
use the method described in \insertCite{andrews91b}{CPAT},
as used in \pkg{cointReg}); this parameter has no effect if
\code{use_kernel_var} is \code{FALSE}}

\item{n}{The sample size for each realization}

\item{gen_func}{The function generating the random sample from which the
statistic is computed}

\item{args}{A list of arguments to be passed to \code{gen_func}}

\item{parallel}{Whether to use the \pkg{foreach} and \pkg{doParallel}
packages to parallelize simulation (which needs to be
initialized in the global namespace before use)}
}
\value{
A vector of simulated realizations of the CUSUM statistic
}
\description{
Simulates multiple realizations of the CUSUM statistic.
}
\details{
This differs from \code{sim_Vn()} in that the long-run variance is estimated
with this function, while \code{sim_Vn()} assumes the long-run variance is
known. Estimation can be done in a variety of ways. If \code{use_kernel_var}
is set to \code{TRUE}, long-run variance estimation using kernel-based
techniques will be employed; otherwise, a technique resembling standard
variance estimation will be employed. Any technique employed, though, will
account for the potential break points, as described in
\insertCite{horvathricemiller19;textual}{CPAT}. See the documentation for
\code{\link{stat_Vn}} for more details.

The parameters \code{kernel} and \code{bandwidth} control parameters for
long-run variance estimation using kernel methods. These parameters will be
passed directly to \code{\link{stat_Vn}}.

Versions of the CUSUM statistic, such as the weighted or trimmed statistics,
can be simulated with the function by passing values to \code{kn} and
\code{tau}; again, see the documentation for \code{\link{stat_Vn}}.
}
\examples{
CPAT:::sim_Vn_stat(100)
CPAT:::sim_Vn_stat(100, kn = function(n) {floor(0.1 * n)}, tau = 1/3,
                   use_kernel_var = TRUE, gen_func = CPAT:::rchangepoint,
                   args = list(changepoint = 250, mean2 = 1))
}
\references{
\insertAllCited{}
}
