% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChangePointTests.R
\name{stat_hs}
\alias{stat_hs}
\title{Compute the Hidalgo-Seo Statistic}
\usage{
stat_hs(dat, estimate = FALSE, corr = TRUE, get_all_vals = FALSE,
  custom_var = NULL, use_kernel_var = FALSE, kernel = "ba",
  bandwidth = "and")
}
\arguments{
\item{dat}{The data vector}

\item{estimate}{Set to \code{TRUE} to return the estimated location of the
change point}

\item{corr}{If \code{TRUE}, the long-run variance will be computed under the
assumption of correlated residuals; ignored if \code{custom_var}
is not \code{NULL} or \code{use_kernel_var} is \code{TRUE}}

\item{get_all_vals}{If \code{TRUE}, return all values for the statistic at
every tested point in the data set}

\item{custom_var}{Can be a vector the same length as \code{dat} consisting of
variance-like numbers at each potential change point (so
each entry of the vector would be the "best estimate" of
the long-run variance if that location were where the
change point occured) or a function taking two parameters
\code{x} and \code{k} that can be used to generate this
vector, with \code{x} representing the data vector and
\code{k} the position of a potential change point; if
\code{NULL}, this argument is ignored}

\item{use_kernel_var}{Set to \code{TRUE} to use kernel methods for long-run
variance estimation (typically used when the data is
believed to be correlated); if \code{FALSE}, then the
long-run variance is estimated using
\eqn{\hat{\sigma}^2_{T,t} = T^{-1}\left(
\sum_{s = 1}^t \left(X_s - \bar{X}_t\right)^2 +
\sum_{s = t + 1}^{T}\left(X_s -
\tilde{X}_{T - t}\right)^2\right)}, where
\eqn{\bar{X}_t = t^{-1}\sum_{s = 1}^t X_s} and
\eqn{\tilde{X}_{T - t} = (T - t)^{-1}
\sum_{s = t + 1}^{T} X_s}; if \code{custom_var} is not
\code{NULL}, this argument is ignored}

\item{kernel}{If character, the identifier of the kernel function as used in
\pkg{cointReg} (see \code{\link[cointReg]{getLongRunVar}}); if
function, the kernel function to be used for long-run variance
estimation (default is the Bartlett kernel in \pkg{cointReg})}

\item{bandwidth}{If character, the identifier for how to compute the
bandwidth as defined in \pkg{cointReg} (see
\code{\link[cointReg]{getBandwidth}}); if function, a function
to use for computing the bandwidth; if numeric, the bandwidth
value to use (the default is to use Andrews' method, as used in
\pkg{cointReg})}
}
\value{
If both \code{estimate} and \code{get_all_vals} are \code{FALSE}, the
        value of the test statistic; otherwise, a list that contains the test
        statistic and the other values requested (if both are \code{TRUE},
        the test statistic is in the first position and the estimated change
        point in the second)
}
\description{
This function computes the Hidalgo-Seo statistic for a change in mean model.
}
\details{
For a data set \eqn{x_t} with \eqn{n} observations, the test statistic is

\deqn{\max_{1 \leq s \leq n - 1} 	(\mathcal{LM}(s) - B_n)/A_n}

where \eqn{\hat{u}_t = x_t - \bar{x}} (\eqn{\bar{x}} is the sample mean),
\eqn{a_n = (2 \log \log n)^{1/2}}, \eqn{b_n = a_n^2 - \frac{1}{2} \log \log
\log n - \log \Gamma (1/2)}, \eqn{A_n = b_n / a_n^2}, \eqn{B_n =
b_n^2/a_n^2}, \eqn{\hat{\Delta} = \hat{\sigma}^2 = n^{-1} \sum_{t = 1}^{n}
\hat{u}_t^2}, and \eqn{\mathcal{LM}(s) = n (n - s)^{-1} s^{-1}
\hat{\Delta}^{-1} \left( \sum_{t = 1}^{s} \hat{u}_t\right)^2}.

If \code{corr} is \code{FALSE}, then the residuals are assumed to be
uncorrelated. Otherwise, the residuals are assumed to be correlated and
\eqn{\hat{\Delta} = \hat{\gamma}(0) + 2 \sum_{j = 1}^{\lfloor \sqrt{n}
\rfloor} (1 - \frac{j}{\sqrt{n}}) \hat{\gamma}(j)} with \eqn{\hat{\gamma}(j)
= \frac{1}{n}\sum_{t = 1}^{n - j} \hat{u}_t \hat{u}_{t + j}}.

This statistic was presented in \insertCite{hidalgoseo13}{CPAT}.
}
\examples{
CPAT:::stat_hs(rnorm(1000))
CPAT:::stat_hs(rnorm(1000), corr = FALSE)
}
\references{
\insertAllCited{}
}
