% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elementwise.R
\docType{class}
\name{MaxElemwise-class}
\alias{MaxElemwise-class}
\alias{.MaxElemwise}
\alias{MaxElemwise}
\alias{to_numeric,MaxElemwise-method}
\alias{sign_from_args,MaxElemwise-method}
\alias{is_atom_convex,MaxElemwise-method}
\alias{is_atom_concave,MaxElemwise-method}
\alias{is_atom_log_log_convex,MaxElemwise-method}
\alias{is_atom_log_log_concave,MaxElemwise-method}
\alias{is_incr,MaxElemwise-method}
\alias{is_decr,MaxElemwise-method}
\alias{is_pwl,MaxElemwise-method}
\alias{.grad,MaxElemwise-method}
\title{The MaxElemwise class.}
\usage{
MaxElemwise(arg1, arg2, ...)

\S4method{to_numeric}{MaxElemwise}(object, values)

\S4method{sign_from_args}{MaxElemwise}(object)

\S4method{is_atom_convex}{MaxElemwise}(object)

\S4method{is_atom_concave}{MaxElemwise}(object)

\S4method{is_atom_log_log_convex}{MaxElemwise}(object)

\S4method{is_atom_log_log_concave}{MaxElemwise}(object)

\S4method{is_incr}{MaxElemwise}(object, idx)

\S4method{is_decr}{MaxElemwise}(object, idx)

\S4method{is_pwl}{MaxElemwise}(object)

\S4method{.grad}{MaxElemwise}(object, values)
}
\arguments{
\item{arg1}{The first \linkS4class{Expression} in the maximum operation.}

\item{arg2}{The second \linkS4class{Expression} in the maximum operation.}

\item{...}{Additional \linkS4class{Expression} objects in the maximum operation.}

\item{object}{A \linkS4class{MaxElemwise} object.}

\item{values}{A list of numeric values for the arguments}

\item{idx}{An index into the atom.}
}
\description{
This class represents the elementwise maximum.
}
\section{Methods (by generic)}{
\itemize{
\item \code{to_numeric(MaxElemwise)}: The elementwise maximum.

\item \code{sign_from_args(MaxElemwise)}: The sign of the atom.

\item \code{is_atom_convex(MaxElemwise)}: The atom is convex.

\item \code{is_atom_concave(MaxElemwise)}: The atom is not concave.

\item \code{is_atom_log_log_convex(MaxElemwise)}: Is the atom log-log convex?

\item \code{is_atom_log_log_concave(MaxElemwise)}: Is the atom log-log concave?

\item \code{is_incr(MaxElemwise)}: The atom is weakly increasing.

\item \code{is_decr(MaxElemwise)}: The atom is not weakly decreasing.

\item \code{is_pwl(MaxElemwise)}: Are all the arguments piecewise linear?

\item \code{.grad(MaxElemwise)}: Gives the (sub/super)gradient of the atom w.r.t. each variable

}}
\section{Slots}{

\describe{
\item{\code{arg1}}{The first \linkS4class{Expression} in the maximum operation.}

\item{\code{arg2}}{The second \linkS4class{Expression} in the maximum operation.}

\item{\code{...}}{Additional \linkS4class{Expression} objects in the maximum operation.}
}}

