% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{cummax_axis}
\alias{cummax_axis}
\alias{cummax}
\alias{cummax,Expression-method}
\title{Cumulative Maximum}
\usage{
cummax_axis(expr, axis = 2)

\S4method{cummax}{Expression}(x)
}
\arguments{
\item{axis}{(Optional) The dimension across which to apply the function: \code{1} indicates rows, and \code{2} indicates columns. The default is \code{2}.}

\item{x, expr}{An \linkS4class{Expression}, vector, or matrix.}
}
\description{
The cumulative maximum, \eqn{\max_{i=1,\ldots,k} x_i} for \eqn{k=1,\ldots,n}.
When calling \code{cummax}, matrices are automatically flattened into column-major order before the max is taken.
}
\examples{
val <- cbind(c(1,2), c(3,4))
value(cummax(Constant(val)))
value(cummax_axis(Constant(val)))

x <- Variable(2,2)
prob <- Problem(Minimize(cummax(x)[4]), list(x == val))
result <- solve(prob)
result$value
result$getValue(cummax(x))
}
