% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify_EngineParams.R
\name{specify_EngineParams}
\alias{specify_EngineParams}
\title{Specify engine parameters for model execution}
\usage{
specify_EngineParams(
  sort = FALSE,
  ODE = c("MatrixExponent", "DVERK", "DOPRI5", "AutoDetect", "Stiff"),
  rtolODE = 1e-06,
  atolODE = 1e-06,
  maxStepsODE = 50000L,
  numIterations = 1000L,
  method = c("FOCE-ELS", "QRPEM", "Laplacian", "Naive-Pooled", "FOCE-LB", "IT2S-EM",
    "FO"),
  stdErr = c("Sandwich", "Auto-Detect", "Hessian", "Fisher-Score", "None"),
  isCentralDiffStdErr = TRUE,
  stepSizeStdErr = 0.01,
  numIntegratePtsAGQ = 1L,
  numIterNonParametric = 0L,
  allowSyntheticGradient = FALSE,
  numIterMAPNP = 0L,
  numRepPCWRES = 0L,
  stepSizeLinearize = 0.002,
  numDigitLaplacian = 7L,
  numDigitBlup = 13L,
  mapAssist = 0L,
  iSample = 300L,
  iAcceptRatio = 0.1,
  impDist = c("Normal", "DoubleExponential", "Direct", "T", "Mixture-2", "Mixture-3"),
  tDOF = 4L,
  numSampleSIR = 10L,
  numBurnIn = 0L,
  freezeOmega = FALSE,
  MCPEM = FALSE,
  runAllIterations = FALSE,
  scramble = c("Owen", "Tezuka-Faur", "None")
)
}
\arguments{
\item{sort}{Logical; Specifying whether or not to sort the input data by
subject and time values. Default is \code{TRUE}.}

\item{ODE}{Character; Specifying the solver used to numerically solve
Ordinary Differential Equations (ODEs). Options are
\itemize{
\item \code{MatrixExponent} (the default),
\item \code{DVERK},
\item \code{DOPRI5},
\item \code{AutoDetect},
\item \code{Stiff}.
}

Note: both \code{DVERK} and \code{DOPRI5} are non-stiff solvers. NLME will
automatically switches to \code{DVERK} if ODEs are nonlinear.}

\item{rtolODE}{Numeric; Specifying relative tolerance for the ODE solver.
Not applicable when \code{ODE == MatrixExponent}.}

\item{atolODE}{Numeric; Specifying absolute tolerance for the ODE solver.}

\item{maxStepsODE}{Numeric; Specifying maximum number of allowable steps or
function evaluations for the ODE solver.}

\item{numIterations}{Numeric; Specifying maximum number of iterations for
estimation.}

\item{method}{Character; Specifying engine method for estimation. Options
are:
\itemize{
\item \code{FOCE-ELS} (the default),
\item \code{QRPEM},
\item \code{Laplacian},
\item \code{Naive-Pooled},
\item \code{FOCE-LB},
\item \code{IT2S-EM},
\item \code{FO}.
}

Note: if model involves any discontinuous observed variable (e.g., count
data) or BQL data, NLME will switch from default method \code{FOCE-ELS} to
\code{Laplacian}.}

\item{stdErr}{Character; Specifying method for standard error computations.
Options are:
\itemize{
\item \code{Auto-Detect} (the default),
\item \code{Sandwich},
\item \code{Hessian},
\item \code{Fisher-Score},
\item \code{None}.
}

Here \code{None} means that standard error calculations are not performed. Since
when \code{method = QRPEM} only \code{Fisher-Score} standard error type is available
in NLME, any selected option except \code{None} will reset to \code{stdErr = "Fisher-Score"}.}

\item{isCentralDiffStdErr}{Logical; Default \code{TRUE} uses central difference
for \code{stdErr} calculations. Set to \code{FALSE} for forward difference method.}

\item{stepSizeStdErr}{Numeric; Specifying the step size used for \code{stdErr}
calculations.}

\item{numIntegratePtsAGQ}{Numeric; Specifying the number of integration
points for adaptive Gaussian quadrature (AGQ) algorithm. Only applicable to
models with \code{method} set to either \code{FOCE-ELS} or \code{Laplacian}.}

\item{numIterNonParametric}{Numeric;  Specifying the number of iterations to
perform non-parametric estimation. Only applicable when \code{method} is not set
to \code{Naive-Pooled} (otherwise ignored).}

\item{allowSyntheticGradient}{Logical, Set to \code{TRUE} to use synthetic
gradient during the estimation process. Only applicable to population
models when \code{method} is not set to \code{Naive-Pooled} (otherwise ignored).}

\item{numIterMAPNP}{Numeric; Specifying the number of iterations to perform
Maximum A Posterior (MAP) initial Naive Pooling (NP) run before estimation.
Only applicable to population models when \code{method} is not set to
\code{Naive-Pooled} (otherwise ignored).}

\item{numRepPCWRES}{Numeric; Specifying the number of replicates to generate
the PCWRES after the simple estimation. Only applicable to population
models when \code{method} is not set to \code{Naive-Pooled} (otherwise ignored).}

\item{stepSizeLinearize}{Numeric; Specifying the step size used for numerical
differentiation when linearizing the model function during the estimation
process.}

\item{numDigitLaplacian}{Numeric; Specifying the number of significant
decimal digits for the Laplacian/ELS algorithm to use to reach convergence.}

\item{numDigitBlup}{Numeric; Specifying the number of significant decimal
digits for the individual estimation to use to reach convergence.}

\item{mapAssist}{Numeric; Specifying the period used to perform MAP
assistance (\code{mapAssist = 0} means that MAP assistance is not performed).
Only applicable when \code{method == "QRPEM"}.}

\item{iSample}{Numeric; Specifying the number of samples. Only applicable
when \code{method == "QRPEM"}.}

\item{iAcceptRatio}{Numeric; Specifying the acceptance ratio. Only applicable
when \code{method == "QRPEM"}.}

\item{impDist}{Character; Specifying the distribution used for important
sampling, and options are
\itemize{
\item \code{Normal} (the default),
\item \code{DoubleExponential},
\item \code{Direct},
\item \code{T},
\item \code{Mixture-2},
\item \code{Mixture-3}.
}

Only applicable to the model with \code{method = "QRPEM"}.}

\item{tDOF}{Numeric; Specifying the degree of freedom (allowed value is
between 3 and 30) for T distribution. Only applicable when \code{method =="QRPEM"}
and \code{impDist == "T"}.}

\item{numSampleSIR}{Numeric; Specifying the number of samples per subject
used in the Sampling Importance Re-Sampling (SIR) algorithm to determine
the number of SIR samples taken from the empirical discrete distribution
that approximates the target conditional distribution. Only applicable to
population models with \code{method = "QRPEM"}.}

\item{numBurnIn}{Numeric; Specifying the number of burn-in iterations to
perform at startup to adjust certain internal parameters. Only applicable
to population models with \code{method = "QRPEM"}.}

\item{freezeOmega}{Logical; Set to \code{TRUE} to freeze Omega but not Theta for
the number of iterations specified in the \code{numBurnIn}. Only applicable to
population models with \code{method = "QRPEM"}.}

\item{MCPEM}{Logical; Set to \code{TRUE} to use Monte-Carlo sampling instead of
Quasi-Random. Only applicable to population models with \code{method = "QRPEM"}.}

\item{runAllIterations}{Logical; Set to \code{TRUE} to execute all requested
iterations specified in \code{numIterations}. Only applicable to population
models with \code{method = "QRPEM"}.}

\item{scramble}{Character; Specifying the quasi-random scrambling method to
use, and options are
\itemize{
\item \code{Owen} (the default),
\item \code{Tezuka-Faur},
\item \code{None}.
}

Only applicable to population models with \code{method = "QRPEM"}.}
}
\value{
Character
}
\description{
Use to define extra engine parameters for model execution.
}
\examples{
# default
EstArgs <- specify_EngineParams()
# QRPEM method
EstArgs <-
  specify_EngineParams(
    sort = TRUE,
    ODE = "DVERK",
    rtolODE = 1e-5,
    atolODE = 1e-5,
    maxStepsODE = 6000,
    numIterations = 100,
    method = "QRPEM",
    numIterMAPNP = 3,
    stdErr = "Fisher-Score",
    isCentralDiffStdErr = FALSE,
    iSample = 350,
    impDist = "Mixture-2",
    scramble = "Tezuka-Faur")

}
\seealso{
\code{\link[=write_ModelTemplateTokens]{write_ModelTemplateTokens()}}, \code{\link[=specify_SimParams]{specify_SimParams()}}
}
