#' Dataset B2 from Fisher
#'
#' Dataset B2 from Fisher (1993) contains measurements of the long-axis
#' orientations of 133 feldspar laths in basalt. Fisher (1993) from
#' Smith (1988)
#'
#'
#' @format A data frame with 133 rows and 1 variable:
#' \describe{
#'   \item{orientations}{Orientation angle in degrees}
#' }
#' @references{Fisher, N.I. (1993) Statistical analysis of circular data. Cambridge University Press.
#' Smith, N.M. (1988) Reconstruction of the Tertiary drainage systems of the Inverell region.
#' Unpublished B.Sc.(Hons.) thesis, Department of Geography, University of Sydney, Australia}
#' @examples
#' data(Datab2fisher)
"Datab2fisher"

#' Dataset B5 from Fisher
#'
#' Dataset B5 from Fisher (1993) contains orientations of 60 feldspar laths in basalt. Fisher (1993) from
#' Smith (1988)
#'
#'
#' @format A data frame with 60 rows and 1 variable:
#' \describe{
#'   \item{orientations}{Orientation angle in degrees}
#' }
#' @references{Fisher, N.I. (1993) Statistical analysis of circular data. Cambridge University Press.
#' Smith, N.M. (1988) Reconstruction of the Tertiary drainage systems of the Inverell region.
#' Unpublished B.Sc.(Hons.) thesis, Departmen of Geography, University of Sydney, Australia}
#' @examples
#' data(Datab5fisher)
"Datab5fisher"


#' Dataset B13 from Fisher
#'
#' Dataset B13 from Fisher (1993) contains measurements of termite mound orientations for
#' the species \emph{Amitermes laurensis}, collected from 14 sites on the Cape York Peninsula,
#' North Queensland, Australia. Experiment reported in Spain et al. (1983)
#'
#'
#' @format A data frame with 906 rows and 4 variables:
#' \describe{
#'   \item{site}{Site number}
#'   \item{latitude}{Latitude of the site}
#'   \item{longitude}{Longitude of the site}
#'   \item{orientation}{Orientation of the mound in degrees}
#' }
#' @references{Fisher, N.I. (1993) Statistical analysis of circular data. Cambridge University Press.
#' Spain, A.V., Okello-Oloya, T. and John, R.D. (1983) Orientation of the termitaria of
#' two species of \emph{Amitermes} (Isoptera:Termitinae) from Northern Queensland.
#' Aust. J. Zoo. 31, 167-177.}
#' @examples
#' data(Datab13fisher)
"Datab13fisher"


#' Dataset B22 from Fisher
#'
#' Dataset B22 from Fisher (1993) includes 63 median directions of face cleats measured at the
#' Wallsend Borehole Colliery in New South Wales, Australia. The median directions were
#' measured at intervals of 20 meters along the coal seam. Fisher (1993) from
#' Shepherd and Fisher (1981, 1982)
#'
#'
#' @format A data frame with 63 rows and 1 variable:
#' \describe{
#'   \item{orientations}{Orientation of the mound in degrees}
#' }
#' @references{Fisher, N.I. (1993) Statistical analysis of circular data. Cambridge University Press.
#' Shepherd, J. and Fisher, N.I. (1981) A rapid method of mapping fracture trends in collieries.
#' Aust. Coal Miner August, 24-33.
#' Shepherd, J. and Fisher, N.I. (1982) A rapid method of mapping fracture trends in collieries.
#' Trans. Soc. Min. Eng. AIME 270, 1931-2.}
#' @examples
#' data(Datab22fisher)
"Datab22fisher"


#' Leaf angles
#'
#' The dataset from Pisek and Adamson (2020) contains leaf inclination angle measurements
#' for 11 species of gum trees (genus \emph{Eucalyptus}) observed at the Huntington
#' Library, Art Collections, and Botanical Gardens in Pasadena, California
#' (latitude 34.125, longitude -118.114, altitude 207 m.a.s.l.)
#'
#'
#' @format A data frame with 999 rows and 3 variable:
#' \describe{
#'   \item{idnumber}{Observation id}
#'   \item{idtype}{Id number of the 11 species of gum trees \\
#'  1  : \emph{balladoniensis} \\
#'  2  : \emph{calycogona} \\
#'  3  : \emph{erythronema} \\
#'  4  : \emph{grossa} \\
#'  5  : \emph{guilfoylei} \\
#'  6  : \emph{lansdowneana} \\
#'  7  : \emph{macrandra} \\
#'  8  : \emph{oleosa} \\
#'  9  : \emph{robusta} \\
#'  10 : \emph{shirleyi} \\
#'  11 : \emph{stoateri}}
#'   \item{leafangle}{Leaf inclination angle in degrees}
#' }
#' @references{Pisek, J. and Adamson, K. (2020). Dataset of leaf inclination angles for 71
#' different \emph{Eucalyptus} species. Data in Brief, 33, 106391}
#' @examples
#' data(Leafangles)
"Leafangles"

