# @file CohortSqlBuilder.R
#
# Copyright 2020 Observational Health Data Sciences and Informatics
#
# This file is part of CirceR
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#     http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

#' Build conceptset SQL
#' 
#' @description 
#' Generates the OMOP CDM Sql to resolve the concept set expression
#'
#' @param conceptSetJSON  a string containing the JSON for the conceptset expression.
#'
#' @return 
#' A character vector containing the OHDSI Sql for the conceptset expression
#' 
#' @export
buildConceptSetQuery <- function(conceptSetJSON) {
  if(inherits(conceptSetJSON,"character") && length(conceptSetJSON) == 1 && nchar(conceptSetJSON) > 0) {
    conceptSetQueryBuilder <- rJava::new(Class = rJava::J("org.ohdsi.circe.vocabulary.ConceptSetExpressionQueryBuilder"))
    return(conceptSetQueryBuilder$buildExpressionQuery(conceptSetExpressionFromJson(conceptSetJSON)))
  } else {
    stop("conceptSetJSON must be a single non-zero length string.")
  }
}