% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_functions.R
\name{predict_KMeans}
\alias{predict_KMeans}
\alias{predict.KMeansCluster}
\title{Prediction function for the k-means}
\usage{
predict_KMeans(data, CENTROIDS, threads = 1, fuzzy = FALSE)

\method{predict}{KMeansCluster}(object, newdata, fuzzy = FALSE, threads = 1, ...)
}
\arguments{
\item{data}{matrix or data frame}

\item{CENTROIDS}{a matrix of initial cluster centroids. The rows of the CENTROIDS matrix should be equal to the number of clusters and the columns should be equal to the columns of the data.}

\item{threads}{an integer specifying the number of cores to run in parallel}

\item{fuzzy}{either TRUE or FALSE. If TRUE, then probabilities for each cluster will be returned based on the distance between observations and centroids.}

\item{object, newdata, ...}{arguments for the `predict` generic}
}
\value{
a vector (clusters)
}
\description{
Prediction function for the k-means
}
\details{
This function takes the data and the output centroids and returns the clusters.
}
\examples{

data(dietary_survey_IBS)

dat = dietary_survey_IBS[, -ncol(dietary_survey_IBS)]

dat = center_scale(dat)

km = KMeans_rcpp(dat, clusters = 2, num_init = 5, max_iters = 100, initializer = 'kmeans++')

pr = predict_KMeans(dat, km$centroids, threads = 1)
}
\author{
Lampros Mouselimis
}
