% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_functions.R
\name{coCluster_matrix}
\alias{coCluster_matrix}
\title{Calculate the Co-cluster matrix for a given set of clustering results.}
\usage{
coCluster_matrix(X, verbos = TRUE)
}
\arguments{
\item{X}{clustering matrix of Nsamples x Nclusterings.
Zero elements are are considered as unclustered samples}

\item{verbos}{binary value for verbosity (default = \code{TRUE})}
}
\value{
The normalized matrix of Co-cluster frequency of any pairs of samples (Nsamples x Nsamples)
}
\description{
Calculate the Co-cluster matrix for a given set of clustering results.
}
\details{
Co-cluster matrix or consensus matrix (CM) is a method for consensus mechanism explaned in Monti et al. (2003).
}
\examples{
Clustering = cbind(c(1,1,1,2,2,2),
                   c(1,1,2,1,2,2))
coCluster_matrix(Clustering, verbos = FALSE)

}
