% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CC_with_robScore_functions.R
\name{consensus_matrix_multiview}
\alias{consensus_matrix_multiview}
\title{Calculate consensus matrix for multi-data consensus clustering}
\usage{
consensus_matrix_multiview(
  X,
  max.cluster = 5,
  sample.set = NA,
  clustering.method = "hclust",
  adj.conv = TRUE,
  verbos = TRUE
)
}
\arguments{
\item{X}{list of adjacency matrices for different cohorts (or views).}

\item{max.cluster}{maximum number of clusters}

\item{sample.set}{vector of samples the clustering is being applied on. \code{sample.set} can be names or indices.
if \code{sample.set} is \code{NA}, it considers that all the datasets have the same samples with the same order.}

\item{clustering.method}{base clustering method: \code{c("hclust", "spectral", "pam")}}

\item{adj.conv}{binary value to apply soft threshold (default=\code{TRUE})}

\item{verbos}{binary value for verbosity (default=\code{TRUE})}
}
\value{
description list of consensus matrices for each k
}
\description{
Calculate consensus matrix for multi-data consensus clustering
}
\details{
performs multi-data consensus clustering and obtain consensus matrix
Monti et al. (2003) consensus clustering algorithm
}
\examples{
data = multiview_clusters (n = c(40,40,40), hidden.dim = 2, observed.dim = c(2,2,2),
sd.max = .1, sd.noise = 0, hidden.r.range = c(.5,1))
X_observation = data[["observation"]]
Adj = list()
for (i in 1:length(X_observation))
  Adj[[i]] = adj_mat(X_observation[[i]], method = "euclidian")
CM = consensus_matrix_multiview(Adj, max.cluster = 4, verbos = FALSE)

}
