% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/account_stats.R
\name{account_stats}
\alias{account_stats}
\title{account_stats}
\usage{
account_stats(
  coord_graph,
  result,
  weight_threshold = c("full", "fast", "none")
)
}
\arguments{
\item{coord_graph}{an \code{igraph} object generated by \link{generate_coordinated_network}}

\item{result}{a table generated by \link{detect_groups}}

\item{weight_threshold}{The threshold to be used for filtering the graph
(options: "full", "fast", or "none").}
}
\value{
a data.table with summary statistics for each account
}
\description{
Calculate account statistics: total posts shared, average time delta,
average edge symmetry score.
}
\details{
With this helper function, you can obtain summary statistics for the accounts in
the network. When applied to a network for which a narrower \code{time_window} has
been calculated using the \link{flag_speed_share} function, the summary statistics
are computed separately for the full and faster networks depending on the
'weight_threshold' option. When this option is set to "full", metrics are
computed on the set of nodes and edges surpassing the user-defined
edge_weight threshold in the \link{generate_coordinated_network} function. Also,
metrics for nodes and edges in the fastest network are returned, but they are
calculated on the specified subgraph. The same applies when the 'weight_threshold'
option is set to "fast". In this case, metrics are calculated on the fast subgraph.
When the option is set to "null", the entire inputted graph without further
subsetting is considered.

The node share count is performed thanks to the table resulting from the
\link{detect_groups} function. If the user has used the optional
\link{flag_speed_share} function and decides to calculate statistics on
the fastest graph (by setting weight_threshold = "fast"), the share count
is calculated considering only shares made in the fastest time window.
Alternatively, shares in the largest time window are considered (option
weight_threshold = "full" or weight_threshold = "none"). When calculating the
share count, all shares made by accounts are considered, regardless of
whether they are shares of posts shared in a coordinated fashion or not,
according to the edge weight threshold. In other words, this is a measure of
an account's activity in the time window under consideration.
}
