% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GamePropertySimpleGame.R
\name{isSimpleGame}
\alias{isSimpleGame}
\title{Check if game is simple}
\usage{
isSimpleGame(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
\code{TRUE} if the game is essential, else \code{FALSE}.
}
\description{
isSimpleGame checks if a TU game is a simple game.
A TU game is a simple game in the sense of the book by 
Peleg and Sudhoelter (2007), p. 16, if and only if the 
game is monotonic and the values of all coalitions are 
either \code{0} or \code{1}.
}
\examples{
library(CoopGame)
isSimpleGame(c(0,0,0,1,0,1,1))

\donttest{
#Example of a simple game
library(CoopGame) 
v1<-c(0,0,0,0,1,1,1)
isSimpleGame(v1)

#Example of a game which not simple 
library(CoopGame)
v2<-c(0,0,0,0,1,1,2)
isSimpleGame(v2)

#Another example of a game which not simple 
#according to our definition
library(CoopGame) 
v3<-c(1,0,0,0,1,1,1)
isSimpleGame(v3)
}

}
\references{
Peleg B. and Sudhoelter P. (2007) \emph{Theory of cooperative games}, 2nd Edition, Springer, p. 16
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
