% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dCount_naive_bi}
\alias{dCount_naive_bi}
\alias{dCount_naive_user}
\title{Compute count probabilities using naive convolution (bi)}
\usage{
dCount_naive_bi(
  x,
  distPars,
  dist,
  nsteps = 100L,
  time = 1,
  extrap = TRUE,
  cdfout = FALSE,
  logFlag = FALSE
)

dCount_naive_user(
  x,
  distPars,
  extrapolPars,
  survR,
  nsteps = 100L,
  time = 1,
  extrap = TRUE,
  cdfout = FALSE,
  logFlag = FALSE
)
}
\arguments{
\item{x}{integer (vector), the desired count values.}

\item{distPars}{\code{Rcpp::List} with distribution specific slots,
see details.}

\item{dist}{character name of the built-in distribution, see details.}

\item{nsteps}{unsiged integer number of steps used to compute the integral.}

\item{time}{double time at wich to compute the probabilities. Set to 1 by
default.}

\item{extrap}{logical if \code{TRUE}, Richardson extrapolation will be
applied to improve accuracy.}

\item{cdfout}{logical if \code{TRUE}, the cdf will be returned instead of
the count probability.}

\item{logFlag}{logical if \code{TRUE} the log-probability will be returned.}

\item{extrapolPars}{ma::vec of length 2. The extrapolation values.}

\item{survR}{Rcpp::Function user passed survival function; should have the
signature \code{function(t, distPars)} where \code{t} is a real number (>0)
where the survival function is evaluated and \code{distPars} is a list of
distribution parameters. It should return a double value.}
}
\value{
vector of probabilities P(x(i)) for i = 1, ..., n where n is
\code{length} of \code{x}.
}
\description{
Compute count probabilities using naive convolution (section 3.1) for the
built-in distributions

Compute count probabilities using naive convolution (section 3.1) for the
user passed survival function.
}
\details{
The routine does minimum number of convolution to compute the count
probability P(x) sing \code{nsteps} steps, and refines result by
Richardson extrapolation if \code{extrap} is \code{TRUE} using the
algorithm of section 3.1.
}
\keyword{internal}
