% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{spectral_norm}
\alias{spectral_norm}
\title{Compute the Spectral Norm Between Estimated Functions.}
\usage{
spectral_norm(est1, est2)
}
\arguments{
\item{est1}{A numeric vector representing the first estimated autocovariance function.}

\item{est2}{A numeric vector of the same length as \code{est1} representing the second estimated autocovariance function}
}
\value{
The spectral norm of the differences between the two functions.
}
\description{
This function computes the spectral norm of the difference of two estimated autocovariance functions.
This function is intended for estimates over lags with a constant difference.
}
\details{
This function computes the spectral norm of the difference of two estimated autocovariance functions.
Let \eqn{D(h) = \hat{C}_{1}(h) - \hat{C}_{2}(h),}
where \eqn{\hat{C}_{1}(\cdot)} and \eqn{\hat{C}_{2}(\cdot)} are estimated autocovariance functions.

A matrix \eqn{D} is created from \eqn{D(\cdot)},
\deqn{\left[ {\begin{array}{ccccc}
D(h_{0})     & D(h_{1})     & \cdots & D(h_{n - 1}) & D(h_{n})     \\
D(h_{1})     & D(h_{0})     & \cdots & D(h_{n - 2}) & D(h_{n - 1}) \\
\vdots       & \vdots       & \ddots & \vdots       & \vdots       \\
D(h_{n - 1}) & D(h_{n - 2}) & \cdots & D(h_{0})     & D(h_{1})     \\
D(h_{n})     & D(h_{n - 1}) & \cdots & D(h_{1})     & D(h_{0})     \\
\end{array}} \right] ,
}
over a set of lags \eqn{\{h_{0}, h_{1}, \dots , h_{N} \}.}
This matrix is created by \link{cyclic_matrix}.

The spectral norm is defined as the largest eigenvalue of \eqn{D.}
}
\examples{
x <- seq(0, 5, by=0.1)
estCov1 <- exp(-x^2)
estCov2 <- exp(-x^2.1)
spectral_norm(estCov1, estCov2)
}
