% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdf5Access.R
\name{readVelocytoLoom}
\alias{readVelocytoLoom}
\title{Extract the raw counts from a LOOM file}
\usage{
readVelocytoLoom(
  filename,
  matrixPath = "layers/spliced",
  cellID = "CellID",
  featureID = "Gene",
  chunkSize = 1000
)
}
\arguments{
\item{filename}{File path to the LOOM file.}

\item{matrixPath}{A path in the LOOM file to the matrix to extract, following
the inner HDF5 structure. Default \code{"layers/spliced"}. See Details.}

\item{cellID}{The name of the cell ID column in the LOOM column-attributes.
The same thing as argument \code{obs_names} of \code{scanpy.read_loom}.
Default \code{"CellID"}.}

\item{featureID}{The name of the feature ID column in the LOOM
row-attributes. The same thing as argument \code{var_names} of
\code{scanpy.read_loom}. Default \code{"Gene"}.}

\item{chunkSize}{The maximum size of the chunk to load the matrix. Default
1000.}
}
\value{
A sparse matrix of class "dgCMatrix", with cells as columns and genes
as rows.
}
\description{
This function is primarily designed for fetching the raw count data from a
LOOM file, output by \href{https://velocyto.org/}{Velocyto}. We by default
use the spliced counts.
}
\details{
The velocyto output LOOM file is HDF5 based and is roughly organized as
follows:
\itemize{
\item{\code{"matrix"}: The whole raw counts, which is the sum of spliced, unspliced
and ambiguous counts.}
\item{layers: A group like a folder
  \itemize{
  \item{\code{"layers/spliced"}: The spliced counts.}
  \item{\code{"layers/unspliced"}: The unspliced counts.}
  \item{\code{"layers/ambiguous"}: The ambiguous counts.}
  }
}
}

An AnnData object created with Scanpy by default loads the data with a
different structure, so that all the four matrices are accessible in
\code{adata.layers} and set one of them (by default \code{"layers/spliced"})
to \code{adata.X}.
}
\examples{
\dontrun{
loomFile <- "velocyto/out/analysis.loom"
rawCounts <- readVelocytoLoom(loomFile)
}
}
\seealso{
Other H5AD-reader: 
\code{\link{readH5ADObsNames}()},
\code{\link{readH5ADObsVar}()},
\code{\link{readH5ADUnsSpMat}()}
}
\concept{H5AD-reader}
