% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_config_env.R
\name{get_config_env}
\alias{get_config_env}
\title{get_config_env helper function}
\usage{
get_config_env(
  system_name,
  logfile_dir = tempdir(),
  headless = TRUE,
  ignore_presets = FALSE,
  uppercase_system = TRUE
)
}
\arguments{
\item{system_name}{The name of the system (This is also the prefix used
to get the environment variables with 'SYSTEM_KEY', e.g. 'I2B2_DBNAME').
This function also works if there are multiple instances like
`I2B2_1_DBNAME` and `I2B2_2_DBNAME`. Then the result will contain
nested lists for each occurence.}

\item{logfile_dir}{(Optional, String, default: "tempdir()")
The absolute path to folder where the logfile will be stored.}

\item{headless}{A boolean (default: `FALSE`). Indicating, if the function is
run only in the console (`headless = TRUE`) or on a GUI frontend
(`headless = FALSE`).}

\item{ignore_presets}{(boolean, default = FALSE)
Only return something if all elements
from the presets are found? These are currently `host`, `port`, `user`,
`password`, `sid`, `path`. If you have another suffix after
`system_name` in your config file, you won't see it here. To see
everything with prefix `system_name` simply set `ignore_presets = TRUE`.
To obtain a list of current default elements, run
\code{DIZutils:::get_default_config_elements()}.}

\item{uppercase_system}{(boolean) Default: True. Otherwise: case-sensitive.}
}
\value{
If successful it returns the config, null otherwise.
}
\description{
Internal function to read settings for a certain system
  from the environment.
  IMPORTANT: If yout want to get any result with your input as prefix,
  use `ignore_presets = TRUE`! See param-definition for more details.
  This function will look at uppercase system_names at default.
}
\examples{
\donttest{
get_config_env(
  system_name = "i2b2",
  logfile_dir = tempdir(),
  headless = FALSE
)}

}
